/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.environment.PropertyValueDescriptor;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;

public class EnvironmentEncryptorEnvironmentRepository
implements EnvironmentRepository {
    private EnvironmentRepository delegate;
    private EnvironmentEncryptor environmentEncryptor;
    private Map<String, String> overrides = new LinkedHashMap<String, String>();

    public EnvironmentEncryptorEnvironmentRepository(EnvironmentRepository delegate) {
        this(delegate, null);
    }

    public EnvironmentEncryptorEnvironmentRepository(EnvironmentRepository delegate, EnvironmentEncryptor environmentEncryptor) {
        this.delegate = delegate;
        this.environmentEncryptor = environmentEncryptor;
    }

    @Override
    public Environment findOne(String name, String profiles, String label) {
        return this.findOne(name, profiles, label, false);
    }

    @Override
    public Environment findOne(String name, String profiles, String label, boolean includeOrigin) {
        Environment environment = this.delegate.findOne(name, profiles, label, includeOrigin);
        if (this.environmentEncryptor != null) {
            environment = this.environmentEncryptor.decrypt(environment);
        }
        if (!this.overrides.isEmpty()) {
            environment.addFirst(new PropertySource("overrides", this.getOverridesMap(includeOrigin)));
        }
        return environment;
    }

    private Map<?, ?> getOverridesMap(boolean includeOrigin) {
        if (!includeOrigin) {
            return this.overrides;
        }
        LinkedHashMap<String, PropertyValueDescriptor> map = new LinkedHashMap<String, PropertyValueDescriptor>();
        for (Map.Entry<String, String> entry : this.overrides.entrySet()) {
            map.put(entry.getKey(), new PropertyValueDescriptor((Object)entry.getValue(), "Config server overrides"));
        }
        return map;
    }

    public void setOverrides(Map<String, String> overrides) {
        this.overrides = new HashMap<String, String>(overrides);
        for (String key : overrides.keySet()) {
            if (overrides.get(key).contains("\\{")) {
                this.overrides.put(key, overrides.get(key).replace("\\{", "{"));
            }
            if (!overrides.get(key).contains("\\${")) continue;
            this.overrides.put(key, overrides.get(key).replace("\\${", "${"));
        }
    }
}

