/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Conditional(value={OnConsulEnabledCondition.class})
public @interface ConditionalOnConsulEnabled {

    public static class OnConsulEnabledCondition
    extends AllNestedConditions {
        public OnConsulEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnClass(value={ConsulClient.class})
        static class FoundClass {
            FoundClass() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.consul.enabled"}, matchIfMissing=true)
        static class FoundProperty {
            FoundProperty() {
            }
        }
    }
}

