/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.catalog.CatalogNodesRequest;
import com.ecwid.consul.v1.catalog.CatalogServiceRequest;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.catalog.model.Node;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.core.style.ToStringCreator;

@Endpoint(id="consul")
public class ConsulEndpoint {
    private ConsulClient consul;

    public ConsulEndpoint(ConsulClient consul) {
        this.consul = consul;
    }

    @ReadOperation
    public ConsulData invoke() {
        ConsulData data = new ConsulData();
        Response agentServices = this.consul.getAgentServices();
        data.setAgentServices((Map)agentServices.getValue());
        Response catalogServices = this.consul.getCatalogServices(CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
        for (String serviceId : ((Map)catalogServices.getValue()).keySet()) {
            Response response = this.consul.getCatalogService(serviceId, CatalogServiceRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
            data.getCatalogServices().put(serviceId, (List<CatalogService>)response.getValue());
        }
        Response catalogNodes = this.consul.getCatalogNodes(CatalogNodesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
        data.setCatalogNodes((List)catalogNodes.getValue());
        return data;
    }

    public static class ConsulData {
        Map<String, List<CatalogService>> catalogServices = new LinkedHashMap<String, List<CatalogService>>();
        Map<String, Service> agentServices;
        List<Node> catalogNodes;

        public Map<String, List<CatalogService>> getCatalogServices() {
            return this.catalogServices;
        }

        public void setCatalogServices(Map<String, List<CatalogService>> catalogServices) {
            this.catalogServices = catalogServices;
        }

        public Map<String, Service> getAgentServices() {
            return this.agentServices;
        }

        public void setAgentServices(Map<String, Service> agentServices) {
            this.agentServices = agentServices;
        }

        public List<Node> getCatalogNodes() {
            return this.catalogNodes;
        }

        public void setCatalogNodes(List<Node> catalogNodes) {
            this.catalogNodes = catalogNodes;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("catalogServices", this.catalogServices).append("agentServices", this.agentServices).append("catalogNodes", this.catalogNodes).toString();
        }
    }
}

