/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.ConsulRawClient;
import java.util.function.Supplier;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulEndpoint;
import org.springframework.cloud.consul.ConsulHealthIndicator;
import org.springframework.cloud.consul.ConsulHealthIndicatorProperties;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.RetryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnConsulEnabled
public class ConsulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulProperties consulProperties() {
        return new ConsulProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsulRawClient.Builder.class}, parameterizedContainer={Supplier.class})
    public Supplier<ConsulRawClient.Builder> consulRawClientBuilderSupplier() {
        return ConsulAutoConfiguration.createConsulRawClientBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulClient consulClient(ConsulProperties consulProperties, Supplier<ConsulRawClient.Builder> consulRawClientBuilderSupplier) {
        return ConsulAutoConfiguration.createConsulClient(consulProperties, consulRawClientBuilderSupplier);
    }

    public static Supplier<ConsulRawClient.Builder> createConsulRawClientBuilder() {
        return ConsulRawClient.Builder::builder;
    }

    public static ConsulClient createConsulClient(ConsulProperties consulProperties, Supplier<ConsulRawClient.Builder> consulRawClientBuilderSupplier) {
        ConsulRawClient.Builder builder = consulRawClientBuilderSupplier.get();
        String agentPath = consulProperties.getPath();
        String agentHost = StringUtils.hasLength((String)consulProperties.getScheme()) ? consulProperties.getScheme() + "://" + consulProperties.getHost() : consulProperties.getHost();
        builder.setHost(agentHost).setPort(consulProperties.getPort());
        if (consulProperties.getTls() != null) {
            ConsulProperties.TLSConfig tls = consulProperties.getTls();
            TLSConfig tlsConfig = new TLSConfig(tls.getKeyStoreInstanceType(), tls.getCertificatePath(), tls.getCertificatePassword(), tls.getKeyStorePath(), tls.getKeyStorePassword());
            builder.setTlsConfig(tlsConfig);
        }
        if (StringUtils.hasLength((String)agentPath)) {
            String normalizedAgentPath = StringUtils.trimTrailingCharacter((String)agentPath, (char)'/');
            normalizedAgentPath = StringUtils.trimLeadingCharacter((String)normalizedAgentPath, (char)'/');
            builder.setPath(normalizedAgentPath);
        }
        return new ConsulClient(builder.build());
    }

    @ConditionalOnClass(value={Retryable.class, Aspect.class, AopAutoConfiguration.class})
    @Configuration(proxyBeanMethods=false)
    @EnableRetry(proxyTargetClass=true)
    @Import(value={AopAutoConfiguration.class})
    @EnableConfigurationProperties(value={RetryProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.consul.retry.enabled"}, matchIfMissing=true)
    protected static class RetryConfiguration {
        protected RetryConfiguration() {
        }

        @Bean(name={"consulRetryInterceptor"})
        @ConditionalOnMissingBean(name={"consulRetryInterceptor"})
        public RetryOperationsInterceptor consulRetryInterceptor(RetryProperties properties) {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).maxAttempts(properties.getMaxAttempts()).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class})
    @EnableConfigurationProperties(value={ConsulHealthIndicatorProperties.class})
    protected static class ConsulHealthConfig {
        protected ConsulHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnAvailableEndpoint
        public ConsulEndpoint consulEndpoint(ConsulClient consulClient) {
            return new ConsulEndpoint(consulClient);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledHealthIndicator(value="consul")
        public ConsulHealthIndicator consulHealthIndicator(ConsulClient consulClient, ConsulHealthIndicatorProperties properties) {
            return new ConsulHealthIndicator(consulClient, properties);
        }
    }
}

