/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.consul.ConsulHealthIndicatorProperties;

public class ConsulHealthIndicator
extends AbstractHealthIndicator {
    private ConsulClient consul;
    private ConsulHealthIndicatorProperties properties;

    public ConsulHealthIndicator(ConsulClient consul, ConsulHealthIndicatorProperties properties) {
        this.consul = consul;
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) {
        Response leaderStatus = this.consul.getStatusLeader();
        builder.up().withDetail("leader", leaderStatus.getValue());
        if (this.properties.isIncludeServicesQuery()) {
            Response services = this.consul.getCatalogServices(CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
            builder.withDetail("services", services.getValue());
        }
    }
}

