/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.health.model.HealthService;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public final class ConsulServerUtils {
    private static final Log log = LogFactory.getLog(ConsulServerUtils.class);

    private ConsulServerUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static String findHost(HealthService healthService) {
        HealthService.Service service = healthService.getService();
        HealthService.Node node = healthService.getNode();
        if (StringUtils.hasText((String)service.getAddress())) {
            return ConsulServerUtils.fixIPv6Address(service.getAddress());
        }
        if (StringUtils.hasText((String)node.getAddress())) {
            return ConsulServerUtils.fixIPv6Address(node.getAddress());
        }
        return node.getNode();
    }

    public static String fixIPv6Address(String address) {
        try {
            InetAddress inetAdr = InetAddress.getByName(address);
            if (inetAdr instanceof Inet6Address) {
                return "[" + inetAdr.getHostAddress() + "]";
            }
            return address;
        }
        catch (UnknownHostException e) {
            log.debug((Object)("Not InetAddress: " + address + " , resolved as is."));
            return address;
        }
    }
}

