/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.environment;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class EnvironmentManagerMvcEndpoint
implements MvcEndpoint {
    private EnvironmentManager environment;
    private EnvironmentEndpoint delegate;

    public EnvironmentManagerMvcEndpoint(EnvironmentEndpoint delegate, EnvironmentManager enviroment) {
        this.delegate = delegate;
        this.environment = enviroment;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public Object value(@RequestParam Map<String, String> params) {
        for (String name : params.keySet()) {
            this.environment.setProperty(name, params.get(name));
        }
        return params;
    }

    @RequestMapping(value={"reset"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> reset() {
        return this.environment.reset();
    }

    public void setEnvironmentManager(EnvironmentManager environment) {
        this.environment = environment;
    }

    public String getPath() {
        return "/" + this.delegate.getId();
    }

    public boolean isSensitive() {
        return this.delegate.isSensitive();
    }

    public Class<? extends Endpoint> getEndpointType() {
        return this.delegate.getClass();
    }
}

