/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.text.StringEscapeUtils;
import repackaged.nl.flotsam.xeger.Xeger;

public class WireMockToDslConverter {
    private static final JsonPointer PRIORITY_POINTER = JsonPointer.compile((String)"/priority");
    private static final JsonPointer REQUEST_METHOD_POINTER = JsonPointer.compile((String)"/request/method");
    private static final JsonPointer REQUEST_URL_POINTER = JsonPointer.compile((String)"/request/url");
    private static final JsonPointer REQUEST_URL_PATH_POINTER = JsonPointer.compile((String)"/request/urlPath");
    private static final JsonPointer REQUEST_URL_PATTERN_POINTER = JsonPointer.compile((String)"/request/urlPattern");
    private static final JsonPointer REQUEST_URL_PATH_PATTERN_POINTER = JsonPointer.compile((String)"/request/urlPathPattern");
    private static final JsonPointer REQUEST_HEADERS_POINTER = JsonPointer.compile((String)"/request/headers");
    private static final JsonPointer REQUEST_BODY_POINTER = JsonPointer.compile((String)"/request/bodyPatterns");
    private static final JsonPointer RESPONSE_STATUS_POINTER = JsonPointer.compile((String)"/response/status");
    private static final JsonPointer RESPONSE_BODY_POINTER = JsonPointer.compile((String)"/response/body");
    private static final JsonPointer RESPONSE_HEADERS_POINTER = JsonPointer.compile((String)"/response/headers");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String fromWireMockStub(String wireMockStringStub) {
        return new WireMockToDslConverter().convertFromWireMockStub(wireMockStringStub);
    }

    private String convertFromWireMockStub(String wireMockStringStub) {
        JsonNode wireMockStub = this.parseStubDefinition(wireMockStringStub);
        return this.buildPriority(wireMockStub) + "request {\n" + this.buildRequestMethod(wireMockStub) + this.buildRequestUrl(wireMockStub) + this.buildRequestUrlPattern(wireMockStub) + this.buildRequestUrlPathPattern(wireMockStub) + this.buildRequestUrlPath(wireMockStub) + this.buildRequestHeaders(wireMockStub) + this.buildRequestBody(wireMockStub) + "}\nresponse {\n" + this.buildResponseStatus(wireMockStub) + this.buildResponseBody(wireMockStub) + this.buildResponseHeaders(wireMockStub) + "}\n";
    }

    private JsonNode parseStubDefinition(String wireMockStringStub) {
        try {
            return OBJECT_MAPPER.reader().readTree(wireMockStringStub);
        }
        catch (IOException e) {
            throw new RuntimeException("WireMock string stub could not be read", e);
        }
    }

    private String buildPriority(JsonNode wireMockStub) {
        String priority = "";
        JsonNode priorityNode = wireMockStub.at(PRIORITY_POINTER);
        if (priorityNode != null && priorityNode.asInt() > 0) {
            priority = "priority " + priorityNode.asInt() + "\n";
        }
        return priority;
    }

    private String buildRequestMethod(JsonNode wireMockStub) {
        String requestMethod = "";
        JsonNode requestMethodNode = wireMockStub.at(REQUEST_METHOD_POINTER);
        if (requestMethodNode != null) {
            requestMethod = "method '" + requestMethodNode.asText() + "'\n";
        }
        return requestMethod;
    }

    private String buildRequestUrl(JsonNode wireMockStub) {
        String requestUrl = "";
        JsonNode requestUrlNode = wireMockStub.at(REQUEST_URL_POINTER);
        if (!requestUrlNode.isMissingNode()) {
            requestUrl = "url '" + requestUrlNode.asText() + "'\n";
        }
        return requestUrl;
    }

    private String buildRequestUrlPath(JsonNode wireMockStub) {
        String requestUrlPath = "";
        JsonNode requestUrlPathNode = wireMockStub.at(REQUEST_URL_PATH_POINTER);
        if (!requestUrlPathNode.isMissingNode()) {
            requestUrlPath = "url '" + requestUrlPathNode.asText() + "'\n";
        }
        return requestUrlPath;
    }

    private String buildRequestUrlPattern(JsonNode wireMockStub) {
        String requestUrlPattern = "";
        JsonNode requestUrlPatternNode = wireMockStub.at(REQUEST_URL_PATTERN_POINTER);
        if (!requestUrlPatternNode.isMissingNode()) {
            String escapedRequestUrlPatternValue = StringEscapeUtils.escapeJava((String)requestUrlPatternNode.asText());
            requestUrlPattern = "url $(consumer(regex('" + escapedRequestUrlPatternValue + "')), producer('" + new Xeger(escapedRequestUrlPatternValue).generate() + "'))\n";
        }
        return requestUrlPattern;
    }

    private String buildRequestUrlPathPattern(JsonNode wireMockStub) {
        String requestUrlPathPattern = "";
        JsonNode requestUrlPathPatternNode = wireMockStub.at(REQUEST_URL_PATH_PATTERN_POINTER);
        if (!requestUrlPathPatternNode.isMissingNode()) {
            String escapedRequestUrlPathPatternValue = StringEscapeUtils.escapeJava((String)requestUrlPathPatternNode.asText());
            requestUrlPathPattern = "urlPath $(consumer(regex('" + escapedRequestUrlPathPatternValue + "')), producer('" + new Xeger(escapedRequestUrlPathPatternValue).generate() + "'))'\n";
        }
        return requestUrlPathPattern;
    }

    private String buildRequestHeaders(JsonNode wireMockStub) {
        StringBuilder requestHeadersBuilder = new StringBuilder();
        JsonNode requestHeadersNode = wireMockStub.at(REQUEST_HEADERS_POINTER);
        if (requestHeadersNode.isObject()) {
            requestHeadersBuilder.append("headers {\n");
            ObjectNode requestHeadersObjectNode = (ObjectNode)requestHeadersNode.deepCopy();
            Iterator fields = requestHeadersObjectNode.fields();
            fields.forEachRemaining(c -> {
                requestHeadersBuilder.append("header('").append((String)c.getKey()).append("',");
                Map.Entry headerValue = (Map.Entry)((JsonNode)c.getValue()).deepCopy().fields().next();
                String header = this.buildHeader((String)headerValue.getKey(), ((JsonNode)headerValue.getValue()).asText());
                requestHeadersBuilder.append(header).append(")").append("\n");
            });
            requestHeadersBuilder.append("}");
        }
        return requestHeadersBuilder.toString();
    }

    private String buildHeader(String method, String value) {
        switch (method) {
            case "equalTo": {
                return "'" + value + "'";
            }
            case "contains": {
                String regex = "^.*" + value + ".*$";
                return "c(regex('" + StringEscapeUtils.escapeJava((String)regex) + "'))";
            }
        }
        return "c(regex('" + StringEscapeUtils.escapeJava((String)value) + "'))";
    }

    private String buildRequestBody(JsonNode wireMockStub) {
        StringBuilder requestBody = new StringBuilder();
        JsonNode requestBodyNode = wireMockStub.at(REQUEST_BODY_POINTER);
        if (requestBodyNode.isArray()) {
            ArrayNode requestBodyArrayNode = (ArrayNode)requestBodyNode.deepCopy();
            Iterator elements = requestBodyArrayNode.elements();
            Iterable iterableFields = () -> elements;
            ArrayList requestBodyObjectNodes = new ArrayList();
            StreamSupport.stream(iterableFields.spliterator(), false).filter(f -> f instanceof ObjectNode).map(f -> (ObjectNode)f).map(ObjectNode::fields).forEachOrdered(i -> i.forEachRemaining(requestBodyObjectNodes::add));
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("equalTo")).findFirst().ifPresent(b -> requestBody.append("body ('").append(((JsonNode)b.getValue()).asText()).append("')"));
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("equalToJson")).findFirst().ifPresent(b -> requestBody.append("body ('").append(((JsonNode)b.getValue()).asText()).append("')"));
            requestBodyObjectNodes.stream().filter(b -> ((String)b.getKey()).equals("matches")).findFirst().ifPresent(b -> requestBody.append("body $(consumer(regex('").append(StringEscapeUtils.escapeJava((String)((JsonNode)b.getValue()).asText())).append("')), producer('").append(new Xeger(StringEscapeUtils.escapeJava((String)((JsonNode)b.getValue()).asText())).generate()).append("'))"));
        }
        return requestBody.toString();
    }

    private String buildResponseStatus(JsonNode wireMockStub) {
        String responseStatus = "";
        JsonNode responseStatusNode = wireMockStub.at(RESPONSE_STATUS_POINTER);
        if (!responseStatusNode.isMissingNode()) {
            int responseStatusValue = responseStatusNode.asInt();
            responseStatus = responseStatus + "status " + responseStatusValue + "\n";
        }
        return responseStatus;
    }

    private String buildResponseBody(JsonNode wireMockStub) {
        String responseBody = "";
        JsonNode responseBodyNode = wireMockStub.at(RESPONSE_BODY_POINTER);
        if (responseBodyNode.isInt()) {
            responseBody = responseBody + "body( " + StringEscapeUtils.escapeJava((String)this.buildPrettyPrintResponseBody((IntNode)responseBodyNode)) + ")\n";
        }
        if (responseBodyNode.isTextual()) {
            responseBody = responseBody + "body( \"" + StringEscapeUtils.escapeJava((String)this.buildPrettyPrintResponseBody((TextNode)responseBodyNode)) + "\")\n";
        }
        return responseBody;
    }

    private String buildPrettyPrintResponseBody(IntNode node) {
        return node.asText();
    }

    private String buildPrettyPrintResponseBody(TextNode node) {
        try {
            String textNode = node.asText();
            Object intermediateObjectForPrettyPrinting = OBJECT_MAPPER.reader().readValue(textNode, Object.class);
            DefaultIndenter customIndenter = new DefaultIndenter("    ", "\n");
            return OBJECT_MAPPER.writer((PrettyPrinter)new PrivatePrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)customIndenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)customIndenter)).writeValueAsString(intermediateObjectForPrettyPrinting);
        }
        catch (IOException e) {
            throw new RuntimeException("WireMock response body could not be pretty printed");
        }
    }

    private String buildResponseHeaders(JsonNode wireMockStub) {
        StringBuilder responseHeadersBuilder = new StringBuilder();
        JsonNode requestHeadersNode = wireMockStub.at(RESPONSE_HEADERS_POINTER);
        if (requestHeadersNode.isObject()) {
            responseHeadersBuilder.append("headers {\n");
            ObjectNode responseHeadersObjectNode = (ObjectNode)requestHeadersNode.deepCopy();
            Iterator fields = responseHeadersObjectNode.fields();
            fields.forEachRemaining(c -> responseHeadersBuilder.append("header('").append((String)c.getKey()).append("',").append("'").append(((JsonNode)c.getValue()).asText()).append("')\n"));
            responseHeadersBuilder.append("}");
        }
        return responseHeadersBuilder.toString();
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    private static class PrivatePrettyPrinter
    extends DefaultPrettyPrinter {
        private PrivatePrettyPrinter() {
        }

        public DefaultPrettyPrinter createInstance() {
            return new PrivatePrettyPrinter();
        }

        public DefaultPrettyPrinter withSeparators(Separators separators) {
            this._separators = separators;
            this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
            return this;
        }
    }
}

