/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.util.StreamUtils;

public abstract class DslToWireMockConverter
implements StubGenerator<StubMapping> {
    private static final Log log = LogFactory.getLog(DslToWireMockConverter.class);

    @Override
    public String generateOutputFileNameForInput(String inputFileName) {
        return inputFileName.replaceAll(this.extension(inputFileName), "json");
    }

    private String extension(String inputFileName) {
        int i = inputFileName.lastIndexOf(".");
        if (i > 0) {
            return inputFileName.substring(i + 1);
        }
        return "";
    }

    @Override
    public boolean canReadStubMapping(File mapping) {
        boolean bl;
        block10: {
            if (!mapping.getName().endsWith(".json")) {
                return false;
            }
            InputStream stream = Files.newInputStream(mapping.toPath(), new OpenOption[0]);
            try {
                StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName("UTF-8")));
                bl = true;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Cannot read file", e);
                    }
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }
}

