/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.contract.stubrunner.PactResource;
import org.springframework.cloud.contract.stubrunner.PactStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public final class PactStubDownloaderBuilder
implements StubDownloaderBuilder {
    private static final List<String> ACCEPTABLE_PROTOCOLS = Collections.singletonList("pact");

    private static boolean isProtocolAccepted(String url) {
        return ACCEPTABLE_PROTOCOLS.stream().anyMatch(url::startsWith);
    }

    public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.getStubsMode() == StubRunnerProperties.StubsMode.CLASSPATH || stubRunnerOptions.getStubRepositoryRoot() == null) {
            return null;
        }
        Resource resource = stubRunnerOptions.getStubRepositoryRoot();
        if (!(resource instanceof PactResource)) {
            return null;
        }
        return new PactStubDownloader(stubRunnerOptions);
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (StringUtils.isEmpty((Object)location) || !PactStubDownloaderBuilder.isProtocolAccepted(location)) {
            return null;
        }
        return new PactResource(location);
    }
}

