/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.core.model.matchingrules.Category;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.EqualsMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.NullMatcher;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;

final class MatchingRulesConverter {
    private MatchingRulesConverter() {
    }

    static Category matchingRulesForBody(BodyMatchers bodyMatchers) {
        return MatchingRulesConverter.matchingRulesFor("body", bodyMatchers);
    }

    private static Category matchingRulesFor(String categoryName, BodyMatchers bodyMatchers) {
        Category category = new Category(categoryName);
        bodyMatchers.matchers().forEach(b -> {
            String key = MatchingRulesConverter.getMatcherKey(b.path());
            MatchingType matchingType = b.matchingType();
            switch (matchingType) {
                case NULL: {
                    category.addRule(key, (MatchingRule)NullMatcher.INSTANCE);
                    break;
                }
                case EQUALITY: {
                    category.addRule(key, (MatchingRule)EqualsMatcher.INSTANCE);
                    break;
                }
                case TYPE: {
                    if (b.minTypeOccurrence() != null && b.maxTypeOccurrence() != null) {
                        category.addRule(key, (MatchingRule)new MinMaxTypeMatcher(b.minTypeOccurrence().intValue(), b.maxTypeOccurrence().intValue()));
                        break;
                    }
                    if (b.minTypeOccurrence() != null) {
                        category.addRule(key, (MatchingRule)new MinTypeMatcher(b.minTypeOccurrence().intValue()));
                        break;
                    }
                    if (b.maxTypeOccurrence() != null) {
                        category.addRule(key, (MatchingRule)new MaxTypeMatcher(b.maxTypeOccurrence().intValue()));
                        break;
                    }
                    category.addRule(key, (MatchingRule)TypeMatcher.INSTANCE);
                    break;
                }
                case DATE: {
                    category.addRule(key, (MatchingRule)new DateMatcher());
                    break;
                }
                case TIME: {
                    category.addRule(key, (MatchingRule)new TimeMatcher());
                    break;
                }
                case TIMESTAMP: {
                    category.addRule(key, (MatchingRule)new TimestampMatcher());
                    break;
                }
                case REGEX: {
                    String pattern = b.value().toString();
                    if (pattern.equals(RegexPatterns.number().pattern())) {
                        category.addRule(key, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER));
                        break;
                    }
                    if (pattern.equals(RegexPatterns.anInteger().pattern())) {
                        category.addRule(key, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
                        break;
                    }
                    if (pattern.equals(RegexPatterns.aDouble().pattern())) {
                        category.addRule(key, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
                        break;
                    }
                    category.addRule(key, (MatchingRule)new RegexMatcher(pattern));
                    break;
                }
            }
        });
        return category;
    }

    private static String getMatcherKey(String path) {
        return path.startsWith("$") ? path.substring(1) : path;
    }
}

