/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.matchingrules.Category;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.NullMatcher;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.core.model.messaging.MessagePact;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchers;
import org.springframework.cloud.contract.verifier.spec.pact.BodyConverter;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;

class MessagingSCContractCreator {
    private static final String FULL_BODY = "$";
    private static final String DESTINATION_KEY = "sentTo";
    private static final List<String> NON_HEADER_META_DATA = Collections.singletonList("sentTo");

    MessagingSCContractCreator() {
    }

    Collection<Contract> convertFrom(MessagePact pact) {
        return pact.getMessages().stream().map(message -> Contract.make(contract -> {
            contract.label(message.getDescription());
            if (CollectionUtils.isNotEmpty((Collection)message.getProviderStates())) {
                contract.input(i -> i.triggeredBy(this.getTriggeredBy((Message)message)));
            }
            contract.outputMessage(outputMessage -> {
                String dest;
                if (message.getContents().isPresent()) {
                    outputMessage.body(BodyConverter.toSCCBody(message));
                    Category bodyRules = message.getMatchingRules().rulesForCategory("body");
                    if (bodyRules != null && MapUtils.isNotEmpty((Map)bodyRules.getMatchingRules())) {
                        outputMessage.bodyMatchers(responseBodyMatchers -> this.outputMessageBodyMatchers((Message)message, bodyRules, (ResponseBodyMatchers)responseBodyMatchers));
                    }
                }
                if (MapUtils.isNotEmpty((Map)message.getMetaData())) {
                    outputMessage.headers(headers -> this.outputMessageHeaders((Message)message, (Headers)headers));
                }
                if (StringUtils.isNotBlank((CharSequence)(dest = this.findDestination((Message)message)))) {
                    outputMessage.sentTo(dest);
                }
            });
        })).collect(Collectors.toList());
    }

    private void outputMessageHeaders(Message message, Headers headers) {
        message.getMetaData().forEach((key, value) -> {
            String matchingRuleGroup = value.toString();
            if (key.equalsIgnoreCase("contentType")) {
                headers.messagingContentType(matchingRuleGroup);
            } else if (!NON_HEADER_META_DATA.contains(key)) {
                headers.header(key, (Object)matchingRuleGroup);
            }
        });
    }

    private void outputMessageBodyMatchers(Message message, Category bodyRules, ResponseBodyMatchers responseBodyMatchers) {
        bodyRules.getMatchingRules().forEach((matchingRuleKey, matchingRuleGroup) -> {
            if (matchingRuleGroup.getRuleLogic() != RuleLogic.AND) {
                throw new UnsupportedOperationException("Currently only the AND combination rule logic is supported");
            }
            if (FULL_BODY.equals(matchingRuleKey)) {
                JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)message.getContents().getValue());
                jsonPaths.forEach(j -> responseBodyMatchers.jsonPath(j.keyBeforeChecking(), responseBodyMatchers.byType()));
            } else {
                matchingRuleGroup.getRules().forEach(rule -> this.applyJsonPathToResponseBodyMatchers((MatchingRule)rule, (String)matchingRuleKey, responseBodyMatchers));
            }
        });
    }

    private String getTriggeredBy(Message message) {
        String triggeredBy = ((ProviderState)message.getProviderStates().get(0)).getName().replaceAll(":", " ").replaceAll(" ", "_").replaceAll("\\(", "").replaceAll("\\)", "");
        return StringUtils.uncapitalize((String)triggeredBy) + "()";
    }

    private String findDestination(Message message) {
        return message.getMetaData().get(DESTINATION_KEY) != null ? message.getMetaData().get(DESTINATION_KEY).toString() : "";
    }

    void applyJsonPathToResponseBodyMatchers(MatchingRule matchingRule, String key, ResponseBodyMatchers responseBodyMatchers) {
        if (matchingRule instanceof NullMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byNull());
        } else if (matchingRule instanceof RegexMatcher) {
            responseBodyMatchers.jsonPath(key, (MatchingTypeValue)responseBodyMatchers.byRegex(((RegexMatcher)matchingRule).getRegex()));
        } else if (matchingRule instanceof DateMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byDate());
        } else if (matchingRule instanceof TimeMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byTime());
        } else if (matchingRule instanceof TimestampMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byTimestamp());
        } else if (matchingRule instanceof MinTypeMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byType(b -> b.minOccurrence(((MinTypeMatcher)matchingRule).getMin())));
        } else if (matchingRule instanceof MinMaxTypeMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byType(c -> {
                c.minOccurrence(((MinMaxTypeMatcher)matchingRule).getMin());
                c.maxOccurrence(((MinMaxTypeMatcher)matchingRule).getMax());
            }));
        } else if (matchingRule instanceof MaxTypeMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byType(c -> c.maxOccurrence(((MaxTypeMatcher)matchingRule).getMax())));
        } else if (matchingRule instanceof TypeMatcher) {
            responseBodyMatchers.jsonPath(key, responseBodyMatchers.byType());
        } else if (matchingRule instanceof NumberTypeMatcher) {
            switch (((NumberTypeMatcher)matchingRule).getNumberType()) {
                case NUMBER: {
                    responseBodyMatchers.jsonPath(key, (MatchingTypeValue)responseBodyMatchers.byRegex(RegexPatterns.number()));
                    break;
                }
                case INTEGER: {
                    responseBodyMatchers.jsonPath(key, (MatchingTypeValue)responseBodyMatchers.byRegex(RegexPatterns.anInteger()));
                    break;
                }
                case DECIMAL: {
                    responseBodyMatchers.jsonPath(key, (MatchingTypeValue)responseBodyMatchers.byRegex(RegexPatterns.aDouble()));
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported number type!");
                }
            }
        }
    }
}

