/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.consumer.MessagePactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.core.model.messaging.MessagePact;
import groovy.lang.GString;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.Input;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.verifier.spec.pact.BodyConverter;
import org.springframework.cloud.contract.verifier.spec.pact.MatchingRulesConverter;
import org.springframework.cloud.contract.verifier.spec.pact.Names;
import org.springframework.cloud.contract.verifier.spec.pact.NamingUtil;
import org.springframework.cloud.contract.verifier.spec.pact.ValueGeneratorConverter;
import org.springframework.cloud.contract.verifier.util.ContentUtils;

class MessagePactCreator {
    private static final Function<DslProperty<?>, Object> clientValueExtractor = DslProperty::getClientValue;

    MessagePactCreator() {
    }

    MessagePact createFromContract(List<Contract> contracts) {
        if (CollectionUtils.isEmpty(contracts)) {
            return null;
        }
        Names names = NamingUtil.name(contracts.get(0));
        MessagePactBuilder pactBuilder = MessagePactBuilder.consumer((String)names.getConsumer()).hasPactWith(names.getProducer());
        for (Contract contract : contracts) {
            pactBuilder = pactBuilder.given(this.getGiven(contract.getInput())).expectsToReceive(this.getOutcome(contract));
            if (contract.getOutputMessage() == null) continue;
            OutputMessage message = contract.getOutputMessage();
            if (message.getBody() != null) {
                DslPart pactResponseBody = BodyConverter.toPactBody(message.getBody(), clientValueExtractor);
                if (message.getBodyMatchers() != null) {
                    pactResponseBody.setMatchers(MatchingRulesConverter.matchingRulesForBody((BodyMatchers)message.getBodyMatchers()));
                }
                pactResponseBody.setGenerators(ValueGeneratorConverter.extract(message, DslProperty::getServerValue));
                pactBuilder = pactBuilder.withContent(pactResponseBody);
            }
            if (message.getHeaders() == null) continue;
            pactBuilder = pactBuilder.withMetadata(this.getMetadata(message.getHeaders()));
        }
        return pactBuilder.toPact();
    }

    private String getGiven(Input input) {
        if (input.getTriggeredBy() != null) {
            return input.getTriggeredBy().getExecutionCommand();
        }
        if (input.getMessageFrom() != null) {
            return "received message from " + clientValueExtractor.apply(input.getMessageFrom());
        }
        return "";
    }

    private String getOutcome(Contract contract) {
        if (contract.getOutputMessage() != null) {
            OutputMessage message = contract.getOutputMessage();
            return "message sent to " + clientValueExtractor.apply(message.getSentTo());
        }
        return "assert that " + contract.getInput().getAssertThat().getExecutionCommand();
    }

    private Map<String, String> getMetadata(Headers headers) {
        return headers.getEntries().stream().collect(Collectors.toMap(Header::getName, this::extractValue));
    }

    private String extractValue(Object value) {
        Object v = value;
        if (v instanceof DslProperty) {
            v = clientValueExtractor.apply((DslProperty)v);
        }
        if (v instanceof GString) {
            v = ContentUtils.extractValue((GString)((GString)v), clientValueExtractor);
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }
}

