/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.List;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.InjectorShell;
import shaded.com.google.inject.spi.DefaultElementVisitor;
import shaded.com.google.inject.spi.Element;

abstract class AbstractProcessor
extends DefaultElementVisitor<Boolean> {
    protected Errors errors;
    protected InjectorImpl injector;

    protected AbstractProcessor(Errors errors) {
        this.errors = errors;
    }

    public void process(Iterable<InjectorShell> isolatedInjectorBuilders) {
        for (InjectorShell injectorShell : isolatedInjectorBuilders) {
            this.process(injectorShell.getInjector(), injectorShell.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InjectorImpl injector, List<Element> elements) {
        Errors errorsAnyElement = this.errors;
        this.injector = injector;
        try {
            elements.removeIf(e -> {
                this.errors = errorsAnyElement.withSource(e.getSource());
                return e.acceptVisitor(this);
            });
        }
        finally {
            this.errors = errorsAnyElement;
            this.injector = null;
        }
    }

    @Override
    protected Boolean visitOther(Element element) {
        return false;
    }
}

