/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.DefaultArtifactVersionWrapper;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;

class FileWalker
extends SimpleFileVisitor<Path> {
    private static final Log log = LogFactory.getLog(FileWalker.class);
    private static final List<String> LATEST = Arrays.asList("latest", "+");
    private static final String RELEASE = "release";
    private final PathMatcher matcherWithDot;
    private final PathMatcher matcherWithoutDot;
    private final boolean latestSnapshotVersion = LATEST.stream().anyMatch(s -> s.equals(stubConfiguration.version.toLowerCase(Locale.ROOT)));
    private final boolean latestReleaseVersion;
    Path foundFile;

    FileWalker(StubConfiguration stubConfiguration) {
        this.latestReleaseVersion = RELEASE.equals(stubConfiguration.version.toLowerCase(Locale.ROOT));
        this.matcherWithDot = FileSystems.getDefault().getPathMatcher("glob:" + this.matcherGlob(stubConfiguration, "."));
        this.matcherWithoutDot = FileSystems.getDefault().getPathMatcher("glob:" + this.matcherGlob(stubConfiguration, "/"));
    }

    private String matcherGlob(StubConfiguration stubConfiguration, String groupArtifactSeparator) {
        return "**" + stubConfiguration.groupId + groupArtifactSeparator + stubConfiguration.artifactId + "/" + (this.latestSnapshotVersion || this.latestReleaseVersion ? "**" : stubConfiguration.version);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.matcherWithDot.matches(dir.toAbsolutePath()) || this.matcherWithoutDot.matches(dir.toAbsolutePath())) {
            if (this.latestSnapshotVersion || this.latestReleaseVersion) {
                File[] files = Objects.requireNonNull(dir.getParent().toFile().listFiles(File::isDirectory));
                File file = this.folderWithPredefinedName(files);
                if (file != null && log.isDebugEnabled()) {
                    log.debug((Object)("Found folder with name corresponding to a latest version [" + file + "] "));
                    this.foundFile = file.toPath();
                    return FileVisitResult.TERMINATE;
                }
                return this.latestVersionFromFolders(dir, files);
            }
            this.foundFile = dir;
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    private FileVisitResult latestVersionFromFolders(Path dir, File[] files) {
        List<DefaultArtifactVersionWrapper> versions = this.pickLatestVersion(files);
        if (versions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not a single version matching semver for path [" + dir.toAbsolutePath().toString() + "] was found"));
            }
            return FileVisitResult.CONTINUE;
        }
        DefaultArtifactVersionWrapper latestFoundVersion = versions.get(versions.size() - 1);
        latestFoundVersion = this.replaceWithSnapshotIfSameVersions(versions, latestFoundVersion);
        this.foundFile = latestFoundVersion.file.toPath();
        return FileVisitResult.TERMINATE;
    }

    private DefaultArtifactVersionWrapper replaceWithSnapshotIfSameVersions(List<DefaultArtifactVersionWrapper> versions, DefaultArtifactVersionWrapper latestFoundVersion) {
        DefaultArtifactVersionWrapper sameVersionButSnapshot;
        if (versions.size() > 1 && this.latestSnapshotVersion && (sameVersionButSnapshot = versions.stream().filter(w -> w.projectVersion.isSameWithoutSuffix(latestFoundVersion.projectVersion) && w.isSnapshot()).findFirst().orElse(latestFoundVersion)) != latestFoundVersion) {
            return sameVersionButSnapshot;
        }
        return latestFoundVersion;
    }

    private File folderWithPredefinedName(File[] files) {
        if (this.latestSnapshotVersion) {
            return Arrays.stream(files).filter(file -> LATEST.stream().anyMatch(s -> s.equals(file.getName().toLowerCase(Locale.ROOT)))).findFirst().orElse(null);
        }
        return Arrays.stream(files).filter(file -> RELEASE.equals(file.getName().toLowerCase(Locale.ROOT))).findFirst().orElse(null);
    }

    private List<DefaultArtifactVersionWrapper> pickLatestVersion(File[] files) {
        return Arrays.stream(files).map(DefaultArtifactVersionWrapper::new).filter(wrapper -> this.latestSnapshotVersion || wrapper.isNotSnapshot()).sorted().collect(Collectors.toList());
    }
}

