/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.http;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.internal.HttpMethods;
import org.springframework.cloud.contract.verifier.http.Body;
import org.springframework.cloud.contract.verifier.http.ContractVerifierHttpMetaData;

public class Request {
    private final ContractVerifierHttpMetaData.Protocol protocol;
    private final ContractVerifierHttpMetaData.Scheme scheme;
    private final HttpMethods.HttpMethod method;
    private final String path;
    private final List<AbstractMap.SimpleEntry<String, String>> queryParameters;
    private final Body body;
    private final Map<String, Object> headers;
    private final Map<String, Object> cookies;

    Request(ContractVerifierHttpMetaData.Protocol protocol, ContractVerifierHttpMetaData.Scheme scheme, HttpMethods.HttpMethod method, String path, List<AbstractMap.SimpleEntry<String, String>> queryParameters, Body body, Map<String, Object> headers, Map<String, Object> cookies) {
        this.protocol = protocol;
        this.scheme = scheme;
        this.method = method;
        this.path = path;
        this.queryParameters = queryParameters == null ? new LinkedList() : queryParameters;
        this.body = body;
        this.headers = headers == null ? new HashMap() : headers;
        this.cookies = cookies == null ? new HashMap() : cookies;
    }

    public String contentType() {
        Object value = ((Map.Entry)this.headers.entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase().equals("content-type")).findFirst().orElse(new AbstractMap.SimpleEntry<String, Object>("", null))).getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public ContractVerifierHttpMetaData.Protocol protocol() {
        return this.protocol;
    }

    public ContractVerifierHttpMetaData.Scheme scheme() {
        return this.scheme;
    }

    public HttpMethods.HttpMethod method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Body body() {
        return this.body;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public Map<String, Object> cookies() {
        return this.cookies;
    }

    public List<AbstractMap.SimpleEntry<String, String>> queryParams() {
        return this.queryParameters;
    }

    public static MethodBuilder given() {
        return new MethodBuilder();
    }

    public static Builder from(Request request) {
        return new MethodBuilder().method(request.method.getMethodName(), request.path).scheme(request.scheme).protocol(request.protocol).queryParams(request.queryParameters).headers(request.headers).cookies(request.cookies).body(request.body);
    }

    public static class Builder {
        HttpMethods.HttpMethod method;
        String path;
        List<AbstractMap.SimpleEntry<String, String>> queryParameters = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
        ContractVerifierHttpMetaData.Protocol protocol = ContractVerifierHttpMetaData.Protocol.HTTP_1_1;
        ContractVerifierHttpMetaData.Scheme scheme = ContractVerifierHttpMetaData.Scheme.HTTP;
        Body body;
        Map<String, Object> headers = new HashMap<String, Object>();
        Map<String, Object> cookies = new HashMap<String, Object>();

        Builder(HttpMethods.HttpMethod method, String path) {
            this.method = method;
            this.path = path;
        }

        public Builder method(HttpMethods.HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = ContractVerifierHttpMetaData.Scheme.fromString(scheme);
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = ContractVerifierHttpMetaData.Protocol.fromString(protocol);
            return this;
        }

        public Builder scheme(ContractVerifierHttpMetaData.Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder protocol(ContractVerifierHttpMetaData.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder body(Object body) {
            this.body = new Body(body);
            return this;
        }

        public Builder queryParam(String name, String value) {
            this.queryParameters.add(new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        public Builder queryParams(List<AbstractMap.SimpleEntry<String, String>> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public Builder header(String key, Object value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder cookie(String key, Object value) {
            this.cookies.put(key, value);
            return this;
        }

        public Builder cookies(Map<String, Object> cookies) {
            this.cookies = cookies;
            return this;
        }

        public Request build() {
            return new Request(this.protocol, this.scheme, this.method, this.path, this.queryParameters, this.body, this.headers, this.cookies);
        }
    }

    public static class MethodBuilder {
        public Builder method(String method, String path) {
            return new Builder(HttpMethods.HttpMethod.valueOf((String)method.toUpperCase()), path);
        }

        public Builder delete(String path) {
            return new Builder(HttpMethods.HttpMethod.DELETE, path);
        }

        public Builder get(String path) {
            return new Builder(HttpMethods.HttpMethod.GET, path);
        }

        public Builder head(String path) {
            return new Builder(HttpMethods.HttpMethod.HEAD, path);
        }

        public Builder options(String path) {
            return new Builder(HttpMethods.HttpMethod.OPTIONS, path);
        }

        public Builder patch(String path) {
            return new Builder(HttpMethods.HttpMethod.PATCH, path);
        }

        public Builder post(String path) {
            return new Builder(HttpMethods.HttpMethod.POST, path);
        }

        public Builder put(String path) {
            return new Builder(HttpMethods.HttpMethod.PUT, path);
        }

        public Builder trace(String path) {
            return new Builder(HttpMethods.HttpMethod.TRACE, path);
        }
    }
}

