/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.CookieElementProcessor;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.MockMvcAcceptor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JaxRsResponseCookiesThen
implements Then,
MockMvcAcceptor,
CookieElementProcessor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;
    private final BodyParser bodyParser;

    JaxRsResponseCookiesThen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyParser = comparisonBuilder.bodyParser();
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        this.processCookies(metadata);
        return this;
    }

    @Override
    public ComparisonBuilder comparisonBuilder() {
        return this.comparisonBuilder;
    }

    @Override
    public BlockBuilder blockBuilder() {
        return this.blockBuilder;
    }

    @Override
    public String cookieKey(String key) {
        return "response.getCookies().get(" + this.bodyParser.quotedShortText(key) + ")";
    }

    @Override
    public String cookieValue(String key) {
        return this.cookieKey(key) + ".getValue()";
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        return response.getCookies() != null;
    }
}

