/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.noop;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=0x7FFFFFFF)
public class NoOpContractVerifierAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MessageVerifier.class})
    public MessageVerifier<?> contractVerifierMessageExchange() {
        return new NoOpStubMessages();
    }

    @Bean
    @ConditionalOnMissingBean(value={ContractVerifierMessaging.class})
    public ContractVerifierMessaging<?> contractVerifierMessaging(MessageVerifier<?> exchange) {
        return new ContractVerifierMessaging(exchange);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierObjectMapper contractVerifierObjectMapper(ObjectProvider<ObjectMapper> objectMapper) {
        ObjectMapper mapper = (ObjectMapper)objectMapper.getIfAvailable();
        if (mapper != null) {
            return new ContractVerifierObjectMapper(mapper);
        }
        return new ContractVerifierObjectMapper();
    }
}

