/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.json.JsonOutput;
import groovy.lang.GString;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.QueryParameter;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.verifier.builder.Path;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.MapConverter;

public class TestSideRequestTemplateModel {
    private final String url;
    private final Map<String, List<Object>> query;
    private final Path path;
    private final Map<String, List<String>> headers;
    private final String body;
    private final String escapedBody;

    private TestSideRequestTemplateModel(String url, Map<String, List<Object>> query, Path path, Map<String, List<String>> headers, String body, String escapedBody) {
        this.url = url;
        this.query = query;
        this.path = path;
        this.headers = headers;
        this.body = body;
        this.escapedBody = escapedBody;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<Object>> getQuery() {
        return this.query;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getEscapedBody() {
        return this.escapedBody;
    }

    public static TestSideRequestTemplateModel from(Request request) {
        Url urlPath = request.getUrl() != null ? request.getUrl() : request.getUrlPath();
        String url = MapConverter.getTestSideValues(urlPath).toString();
        Path paths = new Path(TestSideRequestTemplateModel.buildPathsFromUrl(url));
        QueryParameters queryParameters = urlPath.getQueryParameters();
        Map<String, List<Object>> query = TestSideRequestTemplateModel.query(queryParameters);
        boolean queryParamsPresent = query == null || query.isEmpty();
        String fullUrl = TestSideRequestTemplateModel.fullUrl(url, query, queryParamsPresent);
        boolean headersEntriesPresent = request.getHeaders() != null && !request.getHeaders().getEntries().isEmpty();
        Map<String, List<String>> headers = TestSideRequestTemplateModel.headers(request, headersEntriesPresent);
        String escapedBody = TestSideRequestTemplateModel.trimmedAndEscapedBody(request.getBody());
        String body = TestSideRequestTemplateModel.getBodyAsRawJson(request.getBody());
        return new TestSideRequestTemplateModel(fullUrl, query, paths, headers, body, escapedBody);
    }

    private static Map<String, List<String>> headers(Request request, boolean headersEntriesPresent) {
        if (!headersEntriesPresent) {
            return new HashMap<String, List<String>>();
        }
        return request.getHeaders().getEntries().stream().collect(Collectors.groupingBy(Header::getName, Collectors.mapping(o -> MapConverter.getTestSideValues(o).toString(), Collectors.toList())));
    }

    private static String fullUrl(String url, Map<String, List<Object>> query, boolean queryParamsPresent) {
        if (queryParamsPresent) {
            return url;
        }
        String joinedParams = query.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(s -> (String)entry.getKey() + "=" + s).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
        return url + "?" + joinedParams;
    }

    private static Map<String, List<Object>> query(QueryParameters queryParameters) {
        if (queryParameters == null) {
            return new HashMap<String, List<Object>>();
        }
        return queryParameters.getParameters().stream().collect(Collectors.groupingBy(QueryParameter::getName, Collectors.mapping(MapConverter::getTestSideValues, Collectors.toList())));
    }

    private static List<String> buildPathsFromUrl(String url) {
        LinkedList<String> paths;
        String fakeUrl = "https://foo.bar" + (url.startsWith("/") ? url : "/" + url);
        try {
            paths = new LinkedList<String>(Arrays.asList(new URL(fakeUrl).getPath().split("/")));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        if (!paths.isEmpty()) {
            paths.remove(0);
        }
        return paths;
    }

    private static String trimmedAndEscapedBody(Object body) {
        String rawBody = TestSideRequestTemplateModel.getBodyAsRawJson(body);
        return StringEscapeUtils.escapeJava((String)rawBody);
    }

    private static String getBodyAsRawJson(Object body) {
        String string;
        Object bodyValue = TestSideRequestTemplateModel.extractServerValueFromBody(body);
        if (bodyValue instanceof GString || bodyValue instanceof String) {
            return bodyValue.toString();
        }
        if (bodyValue instanceof FromFileProperty) {
            return null;
        }
        if (bodyValue != null) {
            new JsonOutput();
            string = JsonOutput.toJson((Object)bodyValue);
        } else {
            string = null;
        }
        return string;
    }

    private static Object extractServerValueFromBody(Object bodyValue) {
        bodyValue = bodyValue instanceof GString ? ContentUtils.extractValue((GString)bodyValue, ContentUtils.GET_TEST_SIDE_FUNCTION) : MapConverter.transformValues(bodyValue, ContentUtils.GET_TEST_SIDE_FUNCTION);
        return bodyValue;
    }
}

