/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockRequestStubStrategy;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockResponseStubStrategy;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

public class WireMockStubStrategy {
    private static final String STEP_START = "Started";
    private static final String STEP_PREFIX = "Step";
    private final WireMockRequestStubStrategy wireMockRequestStubStrategy;
    private final WireMockResponseStubStrategy wireMockResponseStubStrategy;
    private final Integer priority;
    private final ContractMetadata contract;
    private final String rootName;
    private final Contract groovyDsl;

    public WireMockStubStrategy(String rootName, ContractMetadata contract, Contract groovyDsl) {
        this.rootName = rootName;
        this.contract = contract;
        SingleContractMetadata singleContractMetadata = contract.forContract(groovyDsl);
        this.wireMockRequestStubStrategy = new WireMockRequestStubStrategy(groovyDsl, singleContractMetadata);
        this.wireMockResponseStubStrategy = new WireMockResponseStubStrategy(groovyDsl, singleContractMetadata);
        this.priority = groovyDsl.getPriority();
        this.groovyDsl = groovyDsl;
    }

    public StubMapping toWireMockClientStub() {
        StubMapping stubMapping = new StubMapping();
        RequestPattern request = this.wireMockRequestStubStrategy.buildClientRequestContent();
        ResponseDefinition response = this.wireMockResponseStubStrategy.buildClientResponseContent();
        if (this.priority != null) {
            stubMapping.setPriority(this.priority);
        }
        stubMapping.setRequest(request);
        stubMapping.setResponse(response);
        if (request == null || response == null) {
            return null;
        }
        if (this.groovyDsl.getIgnored() || this.contract.getIgnored()) {
            return null;
        }
        if (this.contract.getOrder() != null) {
            stubMapping.setScenarioName("Scenario_" + this.rootName);
            stubMapping.setRequiredScenarioState(this.contract.getOrder() == 0 ? STEP_START : STEP_PREFIX + this.contract.getOrder());
            if (this.contract.getOrder() < this.contract.getGroupSize() - 1) {
                stubMapping.setNewScenarioState(STEP_PREFIX + (this.contract.getOrder() + 1));
            }
        }
        return stubMapping;
    }
}

