/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.lang.GString;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.groovy.runtime.GStringImpl;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.util.RegexpUtils;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;

public final class RegexpBuilders {
    private static final String WS = "/\\s*/";
    private static final Function<DslProperty<?>, Object> CLIENT_VALUE_EXTRACTOR = DslProperty::getClientValue;

    private RegexpBuilders() {
    }

    public static String buildGStringRegexpForStubSide(Object o) {
        if (o instanceof DslProperty) {
            return RegexpBuilders.buildGStringRegexpForStubSide((DslProperty)o);
        }
        if (o instanceof Pattern) {
            return RegexpBuilders.buildGStringRegexpForStubSide((Pattern)o);
        }
        if (o instanceof GString) {
            return RegexpBuilders.buildGStringRegexpForStubSide((GString)o);
        }
        return RegexpBuilders.escapeSpecialRegexChars(o.toString());
    }

    static String buildGStringRegexpForStubSide(GString gString) {
        return new GStringImpl(Stream.of(gString.getValues()).map(RegexpBuilders::buildGStringRegexpForStubSide).map(s -> s).toArray(), (String[])Stream.of(gString.getStrings()).map(RegexpBuilders::escapeSpecialRegexChars).toArray(String[]::new)).toString();
    }

    static String buildGStringRegexpForStubSide(Pattern pattern) {
        return pattern.pattern();
    }

    static String buildGStringRegexpForStubSide(DslProperty<?> dslProperty) {
        return RegexpBuilders.buildGStringRegexpForStubSide(dslProperty.getClientValue());
    }

    public static String buildGStringRegexpForTestSide(GString gString) {
        return new GStringImpl(Stream.of(gString.getValues()).map(RegexpBuilders::buildGStringRegexpForTestSide).map(s -> s).toArray(), (String[])Stream.of(gString.getStrings()).map(RegexpBuilders::escapeSpecialRegexChars).toArray(String[]::new)).toString();
    }

    public static String buildGStringRegexpForTestSide(Object o) {
        return o.toString().replaceAll("\\\\", "\\\\\\\\");
    }

    public static String escapeSpecialRegexChars(String str) {
        return RegexpUtils.escapeSpecialRegexChars((String)str);
    }

    public static String buildJSONRegexpMatch(GString gString) {
        return RegexpBuilders.buildJSONRegexpMatch(ContentUtils.extractValue(gString, ContentType.JSON, CLIENT_VALUE_EXTRACTOR));
    }

    public static String buildJSONRegexpMatch(Map<String, Object> jsonMap) {
        return "/\\s*/\\{" + jsonMap.entrySet().stream().map(RegexpBuilders::buildJSONRegexpMatch).collect(Collectors.joining(",")) + "\\}" + WS;
    }

    public static String buildJSONRegexpMatch(List<?> jsonList) {
        return "/\\s*/\\[" + jsonList.stream().map(RegexpBuilders::buildJSONRegexpMatch).collect(Collectors.joining(",")) + "\\]" + WS;
    }

    public static String buildJSONRegexpMatch(Map.Entry<String, Object> entry) {
        return RegexpBuilders.buildJSONRegexpMatchString(StringEscapeUtils.escapeJson((String)entry.getKey())) + ":" + RegexpBuilders.buildJSONRegexpMatch(entry.getValue());
    }

    public static String buildJSONRegexpMatch(Object value) {
        return RegexpBuilders.buildJSONRegexpMatchStringOptionalQuotes(StringEscapeUtils.escapeJson((String)value.toString()));
    }

    public static String buildJSONRegexpMatch(Pattern pattern) {
        return RegexpBuilders.buildJSONRegexpMatchStringOptionalQuotes(pattern.pattern());
    }

    public static String buildJSONRegexpMatchString(String value) {
        return "/\\s*/\"" + value + '\"' + WS;
    }

    public static String buildJSONRegexpMatchStringOptionalQuotes(String value) {
        return "/\\s*/\"?" + value + "\"?" + WS;
    }
}

