/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.CustomModeAcceptor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class CustomModeHeadersThen
implements Then,
CustomModeAcceptor {
    private final BlockBuilder blockBuilder;
    private final ComparisonBuilder comparisonBuilder;

    CustomModeHeadersThen(BlockBuilder blockBuilder, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.comparisonBuilder = comparisonBuilder;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        Headers headers = response.getHeaders();
        Iterator iterator = headers.getEntries().iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            String text = this.processHeaderElement(header.getName(), header.getServerValue() instanceof NotToEscapePattern ? header.getServerValue() : MapConverter.getTestSideValues(header.getServerValue()));
            if (iterator.hasNext()) {
                this.blockBuilder.addLineWithEnding(text);
                continue;
            }
            this.blockBuilder.addIndented(text);
        }
        this.blockBuilder.addEndingIfNotPresent();
        return this;
    }

    private String processHeaderElement(String property, Object value) {
        if (value instanceof NotToEscapePattern) {
            return this.comparisonBuilder.assertThat("response.header(\"" + property + "\")") + this.matchesManuallyEscapedPattern((NotToEscapePattern)value);
        }
        if (value instanceof ExecutionProperty) {
            return ((ExecutionProperty)value).insertValue("response.header(\"" + property + "\")");
        }
        return this.comparisonBuilder.assertThat("response.header(\"" + property + "\")", value);
    }

    private String matchesManuallyEscapedPattern(NotToEscapePattern value) {
        return this.comparisonBuilder.matchesEscaped(((Pattern)value.getServerValue()).pattern().replace("\\", "\\\\"));
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        return response.getHeaders() != null;
    }
}

