/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;

public final class ToYamlConverter {
    private static final Logger log = LoggerFactory.getLogger(ToYamlConverter.class);
    private static final YamlContractConverter yamlContractConverter = new YamlContractConverter();
    private static final List<ContractConverter> CONTRACT_CONVERTERS = ToYamlConverter.converters();

    private ToYamlConverter() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    protected static void doReplaceContractWithYaml(ContractConverter converter, File file) {
        if (log.isDebugEnabled()) {
            log.debug("Will replace contract [{}] with a YAML version", (Object)file.getName());
        }
        Collection collection = converter.convertFrom(file);
        if (log.isDebugEnabled()) {
            log.debug("Converted file [{}] to collection of [{}] contracts", (Object)file, (Object)collection.size());
        }
        Object yamls = yamlContractConverter.convertTo(collection);
        if (log.isDebugEnabled()) {
            log.debug("Converted collection of [{}] contracts to [{}] YAML contracts", (Object)collection.size(), (Object)yamls.size());
        }
        file.delete();
        Map<String, byte[]> stored = yamlContractConverter.store((List<YamlContract>)yamls);
        if (log.isDebugEnabled()) {
            log.debug("Dumped YAMLs to following file names {}", stored.keySet());
        }
        stored.forEach((key, value) -> {
            File ymlContractVersion = new File(file.getParentFile(), (String)key);
            try {
                Files.write(ymlContractVersion.toPath(), value, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Written file [{}] with YAML contract definition", (Object)ymlContractVersion);
            }
        });
    }

    public static void replaceContractWithYaml(File baseDir) {
        try {
            Files.walk(baseDir.toPath(), new FileVisitOption[0]).map(Path::toFile).forEach(file -> CONTRACT_CONVERTERS.stream().filter(converter -> converter.isAccepted(file)).findFirst().ifPresent(converter -> ToYamlConverter.doReplaceContractWithYaml(converter, file)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ContractConverter> converters() {
        List converters = SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
        converters.add(YamlContractConverter.INSTANCE);
        converters.add(ContractVerifierDslConverter.INSTANCE);
        return converters;
    }
}

