/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service;

import org.springframework.cloud.ServiceInfoCreator;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceData;

public abstract class UriBasedServiceInfoCreator<SI extends ServiceInfo>
implements ServiceInfoCreator<ServiceInfo, UriBasedServiceData> {
    private final String uriScheme;

    public UriBasedServiceInfoCreator(String uriScheme) {
        this.uriScheme = uriScheme;
    }

    @Override
    public boolean accept(UriBasedServiceData serviceData) {
        return serviceData.getUri().toString().startsWith(this.uriScheme + "://");
    }

    public abstract SI createServiceInfo(String var1, String var2);

    @Override
    public SI createServiceInfo(UriBasedServiceData serviceData) {
        return this.createServiceInfo(serviceData.getKey(), serviceData.getUri());
    }
}

