/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.common;

import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.cloud.util.UriInfo;

@ServiceInfo.ServiceLabel(value="rabbitmq")
public class AmqpServiceInfo
extends UriBasedServiceInfo {
    public static final String URI_SCHEME = "amqp";

    public AmqpServiceInfo(String id, String host, int port, String username, String password, String virtualHost) {
        super(id, URI_SCHEME, host, port, username, password, virtualHost);
    }

    public AmqpServiceInfo(String id, String uri) throws CloudException {
        super(id, uri);
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getVirtualHost() {
        return this.getUriInfo().getPath();
    }

    @Override
    protected UriInfo validateAndCleanUriInfo(UriInfo uriInfo) {
        if (!URI_SCHEME.equals(uriInfo.getScheme())) {
            throw new IllegalArgumentException("wrong scheme in amqp URI: " + uriInfo);
        }
        if (uriInfo.getHost() == null) {
            throw new IllegalArgumentException("missing authority in amqp URI: " + uriInfo);
        }
        int port = uriInfo.getPort();
        if (port == -1) {
            port = 5672;
        }
        String userName = uriInfo.getUserName();
        String password = uriInfo.getPassword();
        if (userName == null || password == null) {
            throw new IllegalArgumentException("missing userinfo in amqp URI: " + uriInfo);
        }
        String path = uriInfo.getPath();
        if (path == null) {
            path = "/";
        } else if (path.indexOf(47) != -1) {
            throw new IllegalArgumentException("multiple segments in path of amqp URI: " + uriInfo);
        }
        return new UriInfo(uriInfo.getScheme(), uriInfo.getHost(), port, uriInfo.getUserName(), uriInfo.getPassword(), path);
    }
}

