/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import java.net.URI;
import java.net.URISyntaxException;

public class UriInfo {
    private String scheme;
    private String host;
    private int port;
    private String userName;
    private String password;
    private String path;
    private URI uri;
    private String query;

    public UriInfo(String scheme, String host, int port, String username, String password) {
        this(scheme, host, port, username, password, "");
    }

    public UriInfo(String scheme, String host, int port, String username, String password, String path) {
        this(scheme, host, port, username, password, path, null);
    }

    public UriInfo(String scheme, String host, int port, String username, String password, String path, String query) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.userName = username;
        this.password = password;
        this.path = path;
        this.query = query;
        this.uri = this.buildUri();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public URI getUri() {
        return this.uri;
    }

    private URI buildUri() {
        String userInfo = null;
        if (this.userName != null && this.password != null) {
            userInfo = this.userName + ":" + this.password;
        }
        String cleanedPath = this.path == null || this.path.startsWith("/") ? this.path : "/" + this.path;
        try {
            return new URI(this.scheme, userInfo, this.host, this.port, cleanedPath, this.query, null);
        }
        catch (URISyntaxException e) {
            String details = String.format("Error creating URI with components: scheme=%s, userInfo=%s, host=%s, port=%d, path=%s, query=%s", this.scheme, userInfo, this.host, this.port, cleanedPath, this.query);
            throw new IllegalArgumentException(details, e);
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

