/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.common;

import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.RelationalServiceInfo;

@ServiceInfo.ServiceLabel(value="db2")
public class DB2ServiceInfo
extends RelationalServiceInfo {
    private static final String JDBC_URL_TYPE = "db2";
    public static final String DB2_SCHEME = "db2";

    public DB2ServiceInfo(String id, String url) {
        super(id, url, "db2");
    }

    @Override
    @ServiceInfo.ServiceProperty(category="connection")
    public String getJdbcUrl() {
        if (this.getUriInfo().getUriString().startsWith("jdbc:")) {
            return this.getUriInfo().getUriString();
        }
        return String.format("jdbc:%s://%s:%d/%s:user=%s;password=%s;", this.jdbcUrlDatabaseType, this.getHost(), this.getPort(), this.getPath(), this.getUserName(), this.getPassword());
    }
}

