/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.common;

import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;

public abstract class RelationalServiceInfo
extends UriBasedServiceInfo {
    public static final String JDBC_PREFIX = "jdbc:";
    protected final String jdbcUrlDatabaseType;

    public RelationalServiceInfo(String id, String uriString, String jdbcUrlDatabaseType) {
        super(id, uriString);
        this.jdbcUrlDatabaseType = jdbcUrlDatabaseType;
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getJdbcUrl() {
        if (this.getUriInfo().getUriString().startsWith(JDBC_PREFIX)) {
            return this.getUriInfo().getUriString();
        }
        return String.format("%s%s://%s%s/%s%s%s", JDBC_PREFIX, this.jdbcUrlDatabaseType, this.getHost(), this.formatPort(), this.getPath(), this.formatUserinfo(), this.formatQuery());
    }

    private String formatPort() {
        if (this.getPort() != -1) {
            return String.format(":%d", this.getPort());
        }
        return "";
    }

    private String formatUserinfo() {
        if (this.getUserName() != null && this.getPassword() != null) {
            return String.format("?user=%s&password=%s", this.getUserName(), this.getPassword());
        }
        if (this.getUserName() != null) {
            return String.format("?user=%s", this.getUserName());
        }
        return "";
    }

    private String formatQuery() {
        if (this.getQuery() != null) {
            if (this.getUserName() == null && this.getPassword() == null) {
                return String.format("?%s", this.getQuery());
            }
            return String.format("&%s", this.getQuery());
        }
        return "";
    }
}

