/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.AbstractPlatformProperties;
import org.springframework.cloud.dataflow.core.Launcher;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.core.TaskPlatformFactory;

public abstract class AbstractTaskPlatformFactory<P extends AbstractPlatformProperties<?>>
implements TaskPlatformFactory {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final P platformProperties;
    protected final String platformType;

    protected AbstractTaskPlatformFactory(P platformProperties, String platformType) {
        this.platformProperties = platformProperties;
        this.platformType = platformType;
    }

    @Override
    public TaskPlatform createTaskPlatform() {
        return new TaskPlatform(this.platformType, this.createLaunchers());
    }

    protected List<Launcher> createLaunchers() {
        ArrayList<Launcher> launchers = new ArrayList<Launcher>();
        for (String account : ((AbstractPlatformProperties)this.platformProperties).getAccounts().keySet()) {
            try {
                launchers.add(this.createLauncher(account));
            }
            catch (Exception e) {
                this.logger.error("{} platform account [{}] could not be registered: {}", new Object[]{this.platformType, account, e});
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return launchers;
    }
}

