/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.cloud.dataflow.core.AbstractEntity;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersion;
import org.springframework.util.Assert;

@Entity
@Table(name="AppRegistration")
public class AppRegistration
extends AbstractEntity
implements Comparable<AppRegistration> {
    private String name;
    private ApplicationType type;
    private String version;
    @Lob
    private URI uri;
    @Lob
    private URI metadataUri;
    private Boolean defaultVersion = false;
    @Enumerated(value=EnumType.STRING)
    private AppBootSchemaVersion bootVersion;
    @Transient
    private HashSet<String> versions;

    public AppRegistration() {
    }

    public AppRegistration(String name, ApplicationType type, URI uri) {
        this(name, type, "", uri, null);
    }

    public AppRegistration(String name, ApplicationType type, URI uri, URI metadataUri) {
        this(name, type, "", uri, metadataUri);
    }

    public AppRegistration(String name, ApplicationType type, String version, URI uri, URI metadataUri) {
        Assert.hasText((String)name, (String)"name is required");
        Assert.notNull((Object)((Object)type), (String)"type is required");
        Assert.notNull((Object)version, (String)"version is required");
        Assert.notNull((Object)uri, (String)"uri is required");
        this.name = name;
        this.type = type;
        this.version = version;
        this.uri = uri;
        this.metadataUri = metadataUri;
    }

    public AppRegistration(String name, ApplicationType type, String version, URI uri, URI metadataUri, AppBootSchemaVersion bootVersion) {
        this(name, type, version, uri, metadataUri);
        this.bootVersion = bootVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public void setType(ApplicationType type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getMetadataUri() {
        return this.metadataUri;
    }

    public void setMetadataUri(URI metadataUri) {
        this.metadataUri = metadataUri;
    }

    public AppBootSchemaVersion getBootVersion() {
        return this.bootVersion == null ? AppBootSchemaVersion.defaultVersion() : this.bootVersion;
    }

    public void setBootVersion(AppBootSchemaVersion bootVersion) {
        this.bootVersion = bootVersion;
    }

    public Boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(Boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public HashSet<String> getVersions() {
        return this.versions;
    }

    public void setVersions(HashSet<String> versions) {
        this.versions = versions;
    }

    public String toString() {
        return "AppRegistration{name='" + this.getName() + '\'' + ", type='" + (Object)((Object)this.getType()) + '\'' + ", version='" + this.getVersion() + '\'' + ", uri=" + this.getUri() + ", metadataUri=" + this.getMetadataUri() + ", bootVersion='" + this.getBootVersion().getBootVersion() + '}';
    }

    @Override
    public int compareTo(AppRegistration that) {
        int i = this.getType().compareTo(that.getType());
        if (i == 0) {
            i = this.getName().compareTo(that.getName());
        }
        if (i == 0) {
            i = this.getVersion().compareTo(that.getVersion());
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AppRegistration appRegistration = (AppRegistration)o;
        return this.getName().equals(appRegistration.getName()) && this.getType().equals((Object)appRegistration.getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType()});
    }
}

