/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.Assert;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum AuditOperationType {
    APP_REGISTRATION(100L, "App Registration"),
    SCHEDULE(200L, "Schedule"),
    STREAM(300L, "Stream"),
    TASK(400L, "Task"),
    LOGIN(500L, "Login");

    private Long id;
    private String name;

    private AuditOperationType(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.name();
    }

    public String getName() {
        return this.name;
    }

    public static AuditOperationType fromId(Long auditOperationTypeId) {
        Assert.notNull((Object)auditOperationTypeId, (String)"Parameter auditOperationTypeId, must not be null.");
        for (AuditOperationType auditOperationType : AuditOperationType.values()) {
            if (!auditOperationType.getId().equals(auditOperationTypeId)) continue;
            return auditOperationType;
        }
        return null;
    }
}

