/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.springframework.cloud.dataflow.core.AuditActionType;
import org.springframework.cloud.dataflow.core.AuditActionTypeConverter;
import org.springframework.cloud.dataflow.core.AuditOperationType;
import org.springframework.cloud.dataflow.core.AuditOperationTypeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="AuditRecords")
@EntityListeners(value={AuditingEntityListener.class})
public class AuditRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="created_by")
    @CreatedBy
    private String createdBy;
    @Column(name="correlation_id")
    private String correlationId;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="audit_data")
    private String auditData;
    @CreatedDate
    @Column(name="created_on")
    private Instant createdOn;
    @NotNull
    @Convert(converter=AuditActionTypeConverter.class)
    @Column(name="audit_action")
    private AuditActionType auditAction;
    @NotNull
    @Convert(converter=AuditOperationTypeConverter.class)
    @Column(name="audit_operation")
    private AuditOperationType auditOperation;
    @Column(name="platformName")
    private String platformName;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Instant getCreatedDateTime() {
        return this.createdOn;
    }

    public AuditActionType getAuditAction() {
        return this.auditAction;
    }

    public void setAuditAction(AuditActionType auditAction) {
        this.auditAction = auditAction;
    }

    public AuditOperationType getAuditOperation() {
        return this.auditOperation;
    }

    public void setAuditOperation(AuditOperationType auditOperation) {
        this.auditOperation = auditOperation;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getAuditData() {
        return this.auditData;
    }

    public void setAuditData(String data) {
        this.auditData = data;
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Instant createdOn) {
        this.createdOn = createdOn;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String toString() {
        return "AuditRecord [id=" + this.id + ", createdOn=" + this.createdOn + ", auditAction=" + (Object)((Object)this.auditAction) + ", auditOperation=" + (Object)((Object)this.auditOperation) + ", platformName=" + this.platformName + "]";
    }
}

