/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.DataFlowAppDefinition;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskNode;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

@Entity
@Table(name="TASK_DEFINITIONS")
public class TaskDefinition
extends DataFlowAppDefinition {
    public static final String SPRING_CLOUD_TASK_NAME = "spring.cloud.task.name";
    @Id
    @Column(name="DEFINITION_NAME")
    private String taskName;
    @Column(name="DEFINITION")
    @Lob
    private String dslText;
    @Column(name="DESCRIPTION")
    private String description;

    public TaskDefinition() {
    }

    TaskDefinition(String registeredAppName, String label, Map<String, String> properties) {
        super(registeredAppName, label, ApplicationType.task, properties);
        this.taskName = registeredAppName;
        this.dslText = "";
    }

    TaskDefinition(String name, String registeredAppName, String label, Map<String, String> properties, String dsl) {
        super(registeredAppName, label, ApplicationType.task, properties);
        this.taskName = name;
        this.dslText = dsl;
    }

    public TaskDefinition(String name, String dsl) {
        this.taskName = name;
        this.dslText = dsl;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        TaskNode taskNode = new TaskParser(name, dsl, true, true).parse();
        if (taskNode.isComposed()) {
            this.setRegisteredAppName(name);
        } else {
            TaskAppNode singleTaskApp = taskNode.getTaskApp();
            this.setRegisteredAppName(singleTaskApp.getName());
            if (singleTaskApp.hasArguments()) {
                for (ArgumentNode argumentNode : singleTaskApp.getArguments()) {
                    properties.put(argumentNode.getName(), argumentNode.getValue());
                }
            }
        }
        properties.put(SPRING_CLOUD_TASK_NAME, name);
        this.appDefinition = new AppDefinition(name, properties);
    }

    public TaskDefinition(String name, String dsl, String description) {
        this(name, dsl);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getDslText() {
        return this.dslText;
    }

    @PostLoad
    public void initialize() {
        HashMap<String, String> properties = new HashMap<String, String>();
        TaskNode taskNode = new TaskParser(this.taskName, this.dslText, true, true).parse();
        if (taskNode.isComposed()) {
            this.setRegisteredAppName(this.taskName);
        } else {
            TaskAppNode singleTaskApp = taskNode.getTaskApp();
            this.setRegisteredAppName(singleTaskApp.getName());
            if (singleTaskApp.hasArguments()) {
                for (ArgumentNode argumentNode : singleTaskApp.getArguments()) {
                    properties.put(argumentNode.getName(), argumentNode.getValue());
                }
            }
        }
        properties.put(SPRING_CLOUD_TASK_NAME, this.taskName);
        this.appDefinition = new AppDefinition(this.taskName, properties);
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("dslText", (Object)this.dslText).append("appDefinition", (Object)this.appDefinition).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dslText == null ? 0 : this.dslText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)obj;
        return !(this.dslText == null ? other.dslText != null : !this.dslText.equals(other.dslText));
    }

    public static class TaskDefinitionBuilder {
        private final Map<String, String> properties = new HashMap<String, String>();
        private String registeredAppName;
        private String label;
        private String dslText;
        private String taskName;

        public static TaskDefinitionBuilder from(DataFlowAppDefinition definition) {
            TaskDefinitionBuilder builder = new TaskDefinitionBuilder();
            builder.setRegisteredAppName(definition.getRegisteredAppName()).setLabel(definition.getName()).addProperties(definition.getProperties());
            return builder;
        }

        public TaskDefinitionBuilder setProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public TaskDefinitionBuilder setDslText(String dslText) {
            this.dslText = dslText;
            return this;
        }

        public TaskDefinitionBuilder setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public TaskDefinitionBuilder addProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public String getRegisteredAppName() {
            return this.registeredAppName;
        }

        public TaskDefinitionBuilder setRegisteredAppName(String registeredAppName) {
            this.registeredAppName = registeredAppName;
            return this;
        }

        public String getLabel() {
            return this.label;
        }

        public TaskDefinitionBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public TaskDefinitionBuilder setProperties(Map<String, String> properties) {
            Assert.notNull(properties, (String)"properties must not be null");
            this.properties.clear();
            this.addProperties(properties);
            return this;
        }

        public TaskDefinition build() {
            if (this.label == null) {
                this.label = this.registeredAppName;
            }
            return new TaskDefinition(this.taskName, this.registeredAppName, this.label, this.properties, this.dslText);
        }
    }
}

