/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.database.support;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.cloud.dataflow.core.database.support.DatabaseType;
import org.springframework.cloud.dataflow.core.database.support.IncrementerType;
import org.springframework.cloud.dataflow.core.database.support.MariaDBSequenceMaxValueIncrementer;
import org.springframework.cloud.dataflow.core.database.support.SqlServerSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MultiSchemaIncrementerFactory
extends DefaultDataFieldMaxValueIncrementerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MultiSchemaIncrementerFactory.class);
    private final DataSource dataSource;

    public MultiSchemaIncrementerFactory(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
    }

    public DataFieldMaxValueIncrementer getIncrementer(String incrementerType, String incrementerName) {
        IncrementerType type;
        DatabaseType databaseType;
        try {
            databaseType = DatabaseType.fromMetaData(this.dataSource);
        }
        catch (MetaDataAccessException e) {
            throw new IllegalStateException(e);
        }
        if (databaseType != null && (type = this.getIncrementerType(databaseType, incrementerName)) == IncrementerType.SEQUENCE) {
            switch (databaseType) {
                case SQLSERVER: {
                    return new SqlServerSequenceMaxValueIncrementer(this.dataSource, incrementerName);
                }
                case MARIADB: {
                    return new MariaDBSequenceMaxValueIncrementer(this.dataSource, incrementerName);
                }
            }
        }
        return super.getIncrementer(incrementerType, incrementerName);
    }

    /*
     * Exception decompiling
     */
    private IncrementerType getIncrementerType(DatabaseType databaseType, String incrementerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 63[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

