/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class Base64Utils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String PREFIX = "base64_";

    public static String encode(String str) {
        if (!StringUtils.hasLength((String)str)) {
            return str;
        }
        return PREFIX + new String(Base64.getEncoder().withoutPadding().encode(str.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET);
    }

    public static String decode(String str) {
        if (!StringUtils.hasLength((String)str)) {
            return str;
        }
        if (str.startsWith(PREFIX)) {
            return new String(Base64.getDecoder().decode(str.substring(PREFIX.length())), DEFAULT_CHARSET);
        }
        return str;
    }

    public static Map<String, String> decodeMap(Map<String, String> map) {
        if (map == null) {
            return map;
        }
        return map.entrySet().stream().collect(Collectors.toMap(e -> Base64Utils.decode((String)e.getKey()), e -> Base64Utils.decode((String)e.getValue())));
    }
}

