/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.DataFlowAppDefinition;
import org.springframework.util.Assert;

public class StreamAppDefinition
extends DataFlowAppDefinition {
    private final String streamName;

    public StreamAppDefinition(String registeredAppName, String label, ApplicationType applicationType, String streamName, Map<String, String> properties) {
        super(registeredAppName, label, applicationType, properties);
        Assert.notNull((Object)streamName, (String)"stream name must not be null");
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.streamName == null ? 0 : this.streamName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamAppDefinition other = (StreamAppDefinition)obj;
        return !(this.streamName == null ? other.streamName != null : !this.streamName.equals(other.streamName));
    }

    @Override
    public String toString() {
        return "StreamAppDefinition [streamName=" + this.streamName + ", name=" + this.appDefinition.getName() + ", type=" + (Object)((Object)this.getApplicationType()) + ", registeredAppName=" + this.getRegisteredAppName() + ", properties=" + this.appDefinition.getProperties() + "]";
    }

    public static class Builder {
        private final Map<String, String> properties = new HashMap<String, String>();
        private String streamName;
        private String registeredAppName;
        private ApplicationType applicationType;
        private String label;

        public static Builder from(StreamAppDefinition definition) {
            Builder builder = new Builder();
            builder.setStreamName(definition.getStreamName()).setRegisteredAppName(definition.getRegisteredAppName()).setApplicationType(definition.getApplicationType()).setLabel(definition.getName()).addProperties(definition.getProperties());
            return builder;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public Builder setStreamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public ApplicationType getApplicationType() {
            return this.applicationType;
        }

        public Builder setApplicationType(ApplicationType applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder setRegisteredAppName(String registeredAppName) {
            this.registeredAppName = registeredAppName;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties.clear();
            this.addProperties(properties);
            return this;
        }

        public Builder addProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public StreamAppDefinition build(String streamName) {
            if (this.label == null) {
                this.setLabel(this.registeredAppName);
            }
            return new StreamAppDefinition(this.registeredAppName, this.label, this.applicationType, streamName, this.properties);
        }
    }
}

