/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.database.support;

import javax.sql.DataSource;
import org.springframework.cloud.dataflow.core.database.support.MultiSchemaIncrementerFactory;
import org.springframework.cloud.task.repository.dao.JdbcTaskExecutionDao;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.cloud.task.repository.support.DatabaseType;
import org.springframework.cloud.task.repository.support.TaskExecutionDaoFactoryBean;
import org.springframework.jdbc.support.MetaDataAccessException;

public class MultiSchemaTaskExecutionDaoFactoryBean
extends TaskExecutionDaoFactoryBean {
    private final DataSource dataSource;
    private final String tablePrefix;

    public MultiSchemaTaskExecutionDaoFactoryBean(DataSource dataSource, String tablePrefix) {
        super(dataSource, tablePrefix);
        this.dataSource = dataSource;
        this.tablePrefix = tablePrefix;
    }

    public TaskExecutionDao getObject() throws Exception {
        String databaseType;
        MultiSchemaIncrementerFactory incrementerFactory = new MultiSchemaIncrementerFactory(this.dataSource);
        JdbcTaskExecutionDao dao = new JdbcTaskExecutionDao(this.dataSource, this.tablePrefix);
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)this.dataSource).name();
        }
        catch (MetaDataAccessException e) {
            throw new IllegalStateException(e);
        }
        dao.setTaskIncrementer(incrementerFactory.getIncrementer(databaseType, this.tablePrefix + "SEQ"));
        return dao;
    }
}

