/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.cloud.dataflow.core.PlatformTaskExecutionInformation;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;

public class AllPlatformsTaskExecutionInformation {
    private List<PlatformTaskExecutionInformation> taskExecutionInformation;

    public AllPlatformsTaskExecutionInformation(List<TaskPlatform> taskPlatforms) {
        this.taskExecutionInformation = this.buildTaskExecutionInformation(taskPlatforms);
    }

    private List<PlatformTaskExecutionInformation> buildTaskExecutionInformation(List<TaskPlatform> taskPlatforms) {
        this.taskExecutionInformation = new ArrayList<PlatformTaskExecutionInformation>();
        taskPlatforms.forEach(taskPlatform -> taskPlatform.getLaunchers().forEach(launcher -> {
            TaskLauncher taskLauncher = launcher.getTaskLauncher();
            this.taskExecutionInformation.add(new PlatformTaskExecutionInformation(launcher.getName(), launcher.getType(), taskLauncher.getMaximumConcurrentTasks(), taskLauncher.getRunningTaskExecutionCount()));
        }));
        Collections.sort(this.taskExecutionInformation, Comparator.comparing(PlatformTaskExecutionInformation::getType));
        return this.taskExecutionInformation;
    }

    public List<PlatformTaskExecutionInformation> getTaskExecutionInformation() {
        return Collections.unmodifiableList(this.taskExecutionInformation);
    }
}

