/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.Assert;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum AuditActionType {
    CREATE(100L, "Create", "Create an Entity"),
    DELETE(200L, "Delete", "Delete an Entity"),
    DEPLOY(300L, "Deploy", "Deploy an Entity"),
    ROLLBACK(400L, "Rollback", "Rollback an Entity"),
    UNDEPLOY(500L, "Undeploy", "Undeploy an Entity"),
    UPDATE(600L, "Update", "Update an Entity");

    private Long id;
    private String name;
    private String description;

    private AuditActionType(Long id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameWithDescription() {
        return this.name + " (" + this.description + ")";
    }

    public static AuditActionType fromId(Long auditActionTypeId) {
        Assert.notNull((Object)auditActionTypeId, (String)"Parameter auditActionTypeId, must not be null.");
        for (AuditActionType auditActionType : AuditActionType.values()) {
            if (!auditActionType.getId().equals(auditActionTypeId)) continue;
            return auditActionType;
        }
        return null;
    }
}

