/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.Map;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.util.Assert;

abstract class DataFlowAppDefinition {
    protected volatile AppDefinition appDefinition;
    private volatile String registeredAppName;
    private volatile ApplicationType applicationType;

    protected DataFlowAppDefinition() {
    }

    protected DataFlowAppDefinition(String registeredAppName, String label, ApplicationType applicationType, Map<String, String> properties) {
        Assert.notNull((Object)registeredAppName, (String)"registeredAppName must not be null");
        Assert.notNull((Object)((Object)applicationType), (String)"applicationType must not be null");
        Assert.notNull((Object)label, (String)"label must not be null");
        this.registeredAppName = registeredAppName;
        this.applicationType = applicationType;
        this.appDefinition = new AppDefinition(label, properties);
    }

    public String getName() {
        return this.appDefinition.getName();
    }

    public String getRegisteredAppName() {
        return this.registeredAppName;
    }

    protected void setRegisteredAppName(String registeredAppName) {
        this.registeredAppName = registeredAppName;
    }

    public Map<String, String> getProperties() {
        return this.appDefinition.getProperties();
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataFlowAppDefinition other = (DataFlowAppDefinition)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.registeredAppName.equals(other.registeredAppName)) {
            return false;
        }
        if (!this.applicationType.equals((Object)other.applicationType)) {
            return false;
        }
        return this.getProperties().equals(other.getProperties());
    }

    public String toString() {
        return "DataFlowAppDefinition [name=" + this.getName() + ", type=" + (Object)((Object)this.getApplicationType()) + ", registeredAppName=" + this.getRegisteredAppName() + ", properties=" + this.appDefinition.getProperties() + "]";
    }
}

