/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.DefinitionUtils;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamApplicationDefinitionBuilder;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.cloud.dataflow.core.StreamDefinitionServiceUtils;
import org.springframework.cloud.dataflow.core.dsl.StreamNode;
import org.springframework.cloud.dataflow.core.dsl.StreamParser;
import org.springframework.util.StringUtils;

public class DefaultStreamDefinitionService
implements StreamDefinitionService {
    @Override
    public StreamNode parse(StreamDefinition streamDefinition) {
        return new StreamParser(streamDefinition.getName(), streamDefinition.getDslText()).parse();
    }

    @Override
    public LinkedList<StreamAppDefinition> getAppDefinitions(StreamDefinition streamDefinition) {
        LinkedList<StreamAppDefinition> appDefinitions = new LinkedList<StreamAppDefinition>();
        String streamName = streamDefinition.getName();
        for (StreamAppDefinition appDefinition : new StreamApplicationDefinitionBuilder(streamName, this.parse(streamDefinition)).build()) {
            appDefinitions.addFirst(appDefinition);
        }
        return appDefinitions;
    }

    @Override
    public String constructDsl(String originalDslText, LinkedList<StreamAppDefinition> streamAppDefinitions) {
        StringBuilder dslBuilder = new StringBuilder();
        int appDefinitionIndex = 0;
        for (StreamAppDefinition appDefinition : streamAppDefinitions) {
            Map props = appDefinition.getProperties();
            String inputDestination = (String)props.get("spring.cloud.stream.bindings.input.destination");
            String outputDestination = (String)props.get("spring.cloud.stream.bindings.output.destination");
            String inputGroup = (String)props.get("spring.cloud.stream.bindings.input.group");
            if (appDefinitionIndex == 0 && StringUtils.hasText((String)inputDestination)) {
                dslBuilder.append(":").append(inputDestination);
                dslBuilder.append(" > ");
            }
            dslBuilder.append(appDefinition.getName());
            if (inputGroup != null && !inputGroup.equals(appDefinition.getStreamName())) {
                dslBuilder.append(" --group=").append(inputGroup);
            }
            if (!appDefinition.getName().equals(appDefinition.getRegisteredAppName())) {
                dslBuilder.append(": ").append(appDefinition.getRegisteredAppName());
            }
            for (String propertyName : props.keySet()) {
                if (dataFlowAddedProperties.contains(propertyName)) continue;
                String propertyValue = this.unescape((String)props.get(propertyName));
                dslBuilder.append(" --").append(propertyName).append("=").append(DefinitionUtils.escapeNewlines(DefinitionUtils.autoQuotes(propertyValue)));
            }
            if (appDefinitionIndex == streamAppDefinitions.size() - 1) {
                if (StringUtils.hasText((String)outputDestination)) {
                    dslBuilder.append(" > ").append(":").append(outputDestination);
                }
            } else if (appDefinition.getApplicationType() != ApplicationType.app) {
                dslBuilder.append(" | ");
            } else {
                dslBuilder.append(" || ");
            }
            ++appDefinitionIndex;
        }
        String dsl = dslBuilder.toString().replace("> bridge >", ">");
        return dsl;
    }

    @Override
    public String redactDsl(StreamDefinition streamDefinition) {
        return this.constructDsl(streamDefinition.getDslText(), StreamDefinitionServiceUtils.sanitizeStreamAppDefinitions(this.getAppDefinitions(streamDefinition)));
    }

    private String unescape(String text) {
        return StringEscapeUtils.unescapeHtml((String)text);
    }
}

