/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.dsl.AppNode;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.SinkDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.SourceDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.StreamNode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StreamApplicationDefinitionBuilder {
    private static final String CONSUMER_GROUP_PARAMETER = "group";
    private final String streamName;
    private final StreamNode streamNode;

    StreamApplicationDefinitionBuilder(String streamName, StreamNode streamNode) {
        Assert.hasText((String)streamName, (String)"streamName is required");
        Assert.notNull((Object)streamNode, (String)"streamNode must not be null");
        this.streamName = streamName;
        this.streamNode = streamNode;
    }

    public List<StreamAppDefinition> build() {
        SourceDestinationNode sourceDestination = this.streamNode.getSourceDestinationNode();
        SinkDestinationNode sinkDestination = this.streamNode.getSinkDestinationNode();
        LinkedList<StreamAppDefinition.Builder> builders = new LinkedList<StreamAppDefinition.Builder>();
        List appNodes = this.streamNode.getAppNodes();
        for (int m = appNodes.size() - 1; m >= 0; --m) {
            AppNode appNode = (AppNode)appNodes.get(m);
            StreamAppDefinition.Builder builder = new StreamAppDefinition.Builder().setRegisteredAppName(appNode.getName()).setLabel(appNode.getLabelName());
            if (appNode.hasArguments()) {
                ArgumentNode[] arguments;
                ArgumentNode[] argumentNodeArray = arguments = appNode.getArguments();
                int n = argumentNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    ArgumentNode argument = argumentNodeArray[i];
                    if (argument.getName().equalsIgnoreCase("inputType")) {
                        builder.setProperty("spring.cloud.stream.bindings.input.contentType", argument.getValue());
                        continue;
                    }
                    if (argument.getName().equalsIgnoreCase("outputType")) {
                        builder.setProperty("spring.cloud.stream.bindings.output.contentType", argument.getValue());
                        continue;
                    }
                    String value = StringUtils.hasText((String)argument.getValue()) ? argument.getValue() : "\\\"\\\"";
                    builder.setProperty(argument.getName(), value);
                }
            }
            if (appNode.isUnboundStreamApp()) {
                builder.setApplicationType(ApplicationType.app);
            } else if (m == 0) {
                if (sourceDestination == null) {
                    builder.setApplicationType(ApplicationType.source);
                } else if (appNodes.size() == 1 && sinkDestination == null) {
                    builder.setApplicationType(ApplicationType.sink);
                } else {
                    builder.setApplicationType(ApplicationType.processor);
                }
            } else if (m < appNodes.size() - 1 || sinkDestination != null) {
                builder.setApplicationType(ApplicationType.processor);
            } else {
                builder.setApplicationType(ApplicationType.sink);
            }
            if (!appNode.isUnboundStreamApp()) {
                if (m > 0) {
                    builder.setProperty("spring.cloud.stream.bindings.input.destination", String.format("%s.%s", this.streamName, ((AppNode)appNodes.get(m - 1)).getLabelName()));
                    builder.setProperty("spring.cloud.stream.bindings.input.group", this.streamName);
                }
                if (m < appNodes.size() - 1) {
                    builder.setProperty("spring.cloud.stream.bindings.output.destination", String.format("%s.%s", this.streamName, appNode.getLabelName()));
                    builder.setProperty("spring.cloud.stream.bindings.output.producer.requiredGroups", this.streamName);
                }
            }
            builders.add(builder);
        }
        if (sourceDestination != null) {
            StreamAppDefinition.Builder sourceAppBuilder = (StreamAppDefinition.Builder)builders.getLast();
            sourceAppBuilder.setProperty("spring.cloud.stream.bindings.input.destination", sourceDestination.getDestinationName());
            String consumerGroupName = this.streamName;
            if (sourceDestination.getArguments() != null) {
                ArgumentNode[] argumentNodes;
                for (ArgumentNode argument : argumentNodes = sourceDestination.getArguments()) {
                    if (!argument.getName().equalsIgnoreCase(CONSUMER_GROUP_PARAMETER)) continue;
                    consumerGroupName = argument.getValue();
                }
            }
            sourceAppBuilder.setProperty("spring.cloud.stream.bindings.input.group", consumerGroupName);
        }
        if (sinkDestination != null) {
            ((StreamAppDefinition.Builder)builders.getFirst()).setProperty("spring.cloud.stream.bindings.output.destination", sinkDestination.getDestinationName());
        }
        ArrayList<StreamAppDefinition> streamAppDefinitions = new ArrayList<StreamAppDefinition>(builders.size());
        for (StreamAppDefinition.Builder builder : builders) {
            streamAppDefinitions.add(builder.build(this.streamName));
        }
        return streamAppDefinitions;
    }
}

