/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

@Entity
@Table(name="STREAM_DEFINITIONS")
public class StreamDefinition {
    @Id
    @Column(name="DEFINITION_NAME")
    private String name;
    @Column(name="DEFINITION")
    @Lob
    private String dslText;
    @Column(name="ORIGINAL_DEFINITION")
    @Lob
    private String originalDslText;
    @Column(name="DESCRIPTION")
    private String description;

    public StreamDefinition() {
    }

    public StreamDefinition(String name, String dslText) {
        Assert.hasText((String)name, (String)"name is required");
        Assert.hasText((String)dslText, (String)"dslText is required");
        this.name = name;
        this.dslText = dslText;
        this.originalDslText = dslText;
    }

    public StreamDefinition(String name, String dslText, String originalDslText) {
        this(name, dslText);
        this.originalDslText = originalDslText;
    }

    public StreamDefinition(String name, String dslText, String originalDslText, String description) {
        this(name, dslText);
        this.originalDslText = originalDslText;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDslText() {
        return this.dslText;
    }

    public String getOriginalDslText() {
        return this.originalDslText;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dslText == null ? 0 : this.dslText.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamDefinition other = (StreamDefinition)obj;
        if (this.dslText == null ? other.dslText != null : !this.dslText.equals(other.dslText)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("definition", (Object)this.dslText).toString();
    }
}

