/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.core.ArgumentSanitizer;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;

public class StreamDefinitionServiceUtils {
    public static LinkedList<StreamAppDefinition> sanitizeStreamAppDefinitions(LinkedList<StreamAppDefinition> streamAppDefinitions) {
        return streamAppDefinitions.stream().map(app -> StreamAppDefinition.Builder.from(app).setProperties(new ArgumentSanitizer().sanitizeProperties(app.getProperties())).build(app.getStreamName())).collect(Collectors.toCollection(LinkedList::new));
    }

    public static Iterator<StreamAppDefinition> getDeploymentOrderIterator(LinkedList<StreamAppDefinition> streamAppDefinitions) {
        return new ReadOnlyIterator<StreamAppDefinition>(streamAppDefinitions.descendingIterator());
    }

    private static class ReadOnlyIterator<T>
    implements Iterator<T> {
        private final Iterator<T> wrapped;

        ReadOnlyIterator(Iterator<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public T next() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

