/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.cloud.dataflow.core.DefinitionUtils;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskDefinitionToDslConverter {
    private static final List<String> dataFlowAddedProperties = Arrays.asList("spring.cloud.task.name");

    public String toDsl(TaskDefinition taskDefinition) {
        if (StringUtils.hasText((String)taskDefinition.getDslText())) {
            TaskParser taskParser = new TaskParser("__dummy", taskDefinition.getDslText(), true, true);
            Assert.isTrue((!taskParser.parse().isComposed() ? 1 : 0) != 0, (String)"The TaskDefinitionToDslConverter doesn't support Composed Tasks!");
        }
        StringBuilder dslBuilder = new StringBuilder();
        Map properties = taskDefinition.getProperties();
        dslBuilder.append(taskDefinition.getRegisteredAppName());
        for (String propertyName : properties.keySet()) {
            if (dataFlowAddedProperties.contains(propertyName)) continue;
            String propertyValue = StringEscapeUtils.unescapeHtml((String)((String)properties.get(propertyName)));
            dslBuilder.append(" --").append(propertyName).append("=").append(DefinitionUtils.escapeNewlines(DefinitionUtils.autoQuotes(propertyValue)));
        }
        return dslBuilder.toString();
    }
}

