/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.util.Assert;

public class DestinationNode
extends AstNode {
    protected final String destinationName;
    protected final ArgumentNode[] arguments;

    public DestinationNode(int startPos, int endPos, String destinationName, ArgumentNode[] arguments) {
        super(startPos, endPos);
        Assert.notNull((Object)destinationName, (String)"'destinationName' must not be null");
        this.arguments = arguments;
        this.destinationName = destinationName;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.getDestinationName());
        if (includePositionalInfo) {
            s.append(":");
            s.append(this.getStartPos()).append(">").append(this.getEndPos());
        }
        if (this.arguments != null) {
            for (ArgumentNode argumentNode : this.arguments) {
                s.append(" --").append(argumentNode.getName()).append("=").append(argumentNode.getValue());
            }
        }
        s.append(")");
        return s.toString();
    }

    public String toString() {
        return ":" + this.getDestinationName();
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public DestinationNode copyOf() {
        return new DestinationNode(this.startPos, this.endPos, this.destinationName, this.arguments);
    }

    ArgumentNode[] getArguments() {
        return this.arguments;
    }
}

