/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;

public class TaskAppNode
extends LabelledTaskNode {
    private Token taskName;
    private ArgumentNode[] arguments;
    private Map<String, String> argumentsMap;
    private List<TransitionNode> transitions;

    TaskAppNode(Token taskName, ArgumentNode[] arguments, List<TransitionNode> transitions) {
        super(taskName.startPos, transitions == null || transitions.isEmpty() ? (arguments == null || arguments.length == 0 ? taskName.endPos : arguments[arguments.length - 1].endPos) : transitions.get((int)(transitions.size() - 1)).endPos);
        this.taskName = taskName;
        this.arguments = arguments;
        this.transitions = transitions;
    }

    public String toString() {
        return "TaskApp: " + this.stringify(true);
    }

    @Override
    public final boolean isTaskApp() {
        return true;
    }

    public List<TransitionNode> getTransitions() {
        return this.transitions;
    }

    void setTransitions(List<TransitionNode> transitions) {
        this.transitions = transitions;
    }

    public boolean hasTransitions() {
        return this.transitions != null && !this.transitions.isEmpty();
    }

    public String getName() {
        return this.taskName.stringValue();
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.length != 0;
    }

    public ArgumentNode[] getArguments() {
        return this.arguments;
    }

    public Map<String, String> getArgumentsAsMap() {
        if (this.argumentsMap == null) {
            if (this.arguments == null || this.arguments.length == 0) {
                this.argumentsMap = Collections.emptyMap();
            } else {
                this.argumentsMap = new LinkedHashMap<String, String>();
                for (ArgumentNode argument : this.arguments) {
                    this.argumentsMap.put(argument.getName(), argument.getValue());
                }
            }
        }
        return this.argumentsMap;
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        if (this.hasLabel()) {
            s.append(this.getLabelString()).append(": ");
        }
        s.append(this.getName());
        if (this.arguments != null) {
            for (ArgumentNode argument : this.arguments) {
                s.append(" ").append("--").append(argument.getName()).append("=").append(argument.getValue());
            }
        }
        if (includePositionInfo) {
            s.append(":").append(this.startPos).append(">").append(this.endPos);
        }
        s.append(" ");
        for (int i = 0; i < this.transitions.size(); ++i) {
            TransitionNode t = this.transitions.get(i);
            if (i > 0) {
                s.append(" ");
            }
            s.append(t.stringify(includePositionInfo));
        }
        return s.toString().trim();
    }

    @Override
    public void accept(TaskVisitor visitor) {
        boolean cont = visitor.preVisit(this);
        if (!cont) {
            return;
        }
        visitor.visit(this);
        for (TransitionNode transition : this.transitions) {
            transition.accept(visitor);
        }
        visitor.postVisit(this);
    }

    public String toDslText() {
        StringBuilder s = new StringBuilder();
        if (this.getLabel() != null) {
            s.append(this.getLabelString()).append(": ");
        }
        s.append(this.taskName.stringValue());
        if (this.getArgumentsAsMap().size() != 0) {
            s.append(" ");
            for (Map.Entry<String, String> argument : this.argumentsMap.entrySet()) {
                s.append("--").append(argument.getKey()).append("=").append(argument.getValue());
            }
        }
        return s.toString();
    }
}

