/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.FlowNode;
import org.springframework.cloud.dataflow.core.dsl.GraphGeneratorVisitor;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskApp;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskValidationProblem;
import org.springframework.cloud.dataflow.core.dsl.TaskValidatorVisitor;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;
import org.springframework.cloud.dataflow.core.dsl.graph.Graph;
import org.springframework.util.Assert;

public class TaskNode
extends AstNode {
    private String name;
    private String taskDSL;
    private List<LabelledTaskNode> sequences;
    private List<TaskApp> taskApps;

    TaskNode(String name, String taskDSL, List<LabelledTaskNode> sequences, boolean inAppMode) {
        super(sequences.size() == 0 ? 0 : sequences.get(0).getStartPos(), sequences.size() == 0 ? 0 : sequences.get(sequences.size() - 1).getEndPos());
        this.name = name;
        this.taskDSL = taskDSL;
        this.sequences = sequences;
    }

    public static String getTaskPrefix(String taskName) {
        return taskName + "-";
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (i > 0) {
                s.append("\n");
            }
            s.append(this.sequences.get(i).stringify(includePositionInfo));
        }
        return s.toString();
    }

    public List<TaskApp> getTaskApps() {
        if (this.taskApps == null) {
            TaskAppsCollector collector = new TaskAppsCollector();
            this.accept(collector);
            this.taskApps = collector.getTaskApps();
        }
        return this.taskApps;
    }

    public void accept(TaskVisitor visitor) {
        Assert.notNull((Object)visitor, (String)"visitor expected to be non-null");
        visitor.startVisit(this.name, this.taskDSL);
        int sequenceNumber = 0;
        for (LabelledTaskNode ctn : this.sequences) {
            if (visitor.preVisitSequence(ctn, sequenceNumber)) {
                ctn.accept(visitor);
                visitor.postVisitSequence(ctn, sequenceNumber);
            }
            ++sequenceNumber;
        }
        visitor.endVisit();
    }

    public Graph toGraph() {
        GraphGeneratorVisitor ggv = new GraphGeneratorVisitor();
        this.accept(ggv);
        return ggv.getGraph();
    }

    public List<TaskValidationProblem> validate() {
        TaskValidatorVisitor validator = new TaskValidatorVisitor();
        this.accept(validator);
        return validator.getProblems();
    }

    public String getName() {
        return this.name;
    }

    public String getTaskText() {
        return this.taskDSL;
    }

    public LabelledTaskNode getStart() {
        if (this.sequences.size() == 0) {
            return null;
        }
        return this.sequences.get(0);
    }

    public List<LabelledTaskNode> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public LabelledTaskNode getSequenceWithLabel(String label) {
        Assert.hasText((String)label, (String)"label is required");
        for (LabelledTaskNode ctn : this.sequences) {
            if (!ctn.hasLabel() || !ctn.getLabelString().equals(label)) continue;
            return ctn;
        }
        return null;
    }

    public String toDSL() {
        return this.stringify(false);
    }

    public String toExecutableDSL() {
        ExecutableDSLVisitor v = new ExecutableDSLVisitor();
        this.accept(v);
        return v.getDSL();
    }

    public boolean isComposed() {
        boolean isOneTask;
        boolean bl = isOneTask = this.sequences.size() == 1 && this.sequences.get(0).isFlow() && ((FlowNode)this.sequences.get(0)).getSeriesLength() == 1 && ((FlowNode)this.sequences.get(0)).getSeriesElement(0).isTaskApp();
        if (!isOneTask) {
            return true;
        }
        TaskAppNode singleNode = (TaskAppNode)((FlowNode)this.sequences.get(0)).getSeriesElement(0);
        return singleNode.hasTransitions();
    }

    public TaskAppNode getTaskApp() {
        return this.isComposed() ? null : (TaskAppNode)((FlowNode)this.sequences.get(0)).getSeriesElement(0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("TaskNode for ").append(this.taskDSL.replaceAll("\n", ";"));
        s.append("\n").append(this.sequences);
        return s.toString();
    }

    class TaskAppsCollector
    extends TaskVisitor {
        private String taskName;
        private List<TaskApp> taskApps = new ArrayList<TaskApp>();

        TaskAppsCollector() {
        }

        @Override
        public void startVisit(String taskName, String taskDSL) {
            this.taskName = taskName;
        }

        @Override
        public void visit(TaskAppNode taskApp) {
            this.taskApps.add(new TaskApp(this.taskName, taskApp));
        }

        @Override
        public void visit(TransitionNode transition) {
            if (transition.isTargetApp()) {
                this.taskApps.add(new TaskApp(this.taskName, transition.getTargetApp()));
            }
        }

        public List<TaskApp> getTaskApps() {
            return this.taskApps;
        }
    }

    static class ExecutableDSLVisitor
    extends TaskVisitor {
        private static final int START_OF_FLOW = 0;
        private static final int START_OF_SPLIT = 1;
        private static final int IN_FLOW = 2;
        private static final int IN_SPLIT = 3;
        private StringBuilder dsl = new StringBuilder();
        private String taskName;
        private Stack<Integer> state = new Stack();

        ExecutableDSLVisitor() {
        }

        @Override
        public void startVisit(String taskName, String taskDSL) {
            this.taskName = taskName;
        }

        @Override
        public boolean preVisit(FlowNode flow) {
            if (!this.state.isEmpty() && this.state.peek() == 3) {
                this.dsl.append(" || ");
            }
            this.state.push(0);
            return true;
        }

        @Override
        public void postVisit(FlowNode flow) {
            this.state.pop();
            if (!this.state.isEmpty() && this.state.peek() == 1) {
                this.state.pop();
                this.state.push(3);
            }
        }

        @Override
        public boolean preVisit(SplitNode split) {
            if (this.state.peek() == 0) {
                this.state.pop();
                this.state.push(2);
            } else if (this.state.peek() == 2) {
                this.dsl.append(" && ");
            }
            this.state.push(1);
            this.dsl.append("<");
            return true;
        }

        @Override
        public void postVisit(SplitNode split) {
            this.dsl.append(">");
            this.state.pop();
        }

        @Override
        public void visit(TaskAppNode taskApp) {
            int currentState = this.state.peek();
            if (currentState == 0) {
                this.state.pop();
                this.state.push(2);
            } else if (currentState == 2) {
                this.dsl.append(" && ");
            } else {
                throw new IllegalStateException("" + this.state.peek());
            }
            this.dsl.append(this.toExecutableDSLTaskName(taskApp));
            List<TransitionNode> transitions = taskApp.getTransitions();
            for (TransitionNode transition : transitions) {
                this.dsl.append(" ");
                this.dsl.append(transition.getStatusToCheckInDSLForm());
                this.dsl.append("->");
                if (transition.isTargetApp()) {
                    this.dsl.append(this.toExecutableDSLTaskName(transition.getTargetApp()));
                    continue;
                }
                this.dsl.append(":").append(transition.getTargetLabel());
            }
        }

        private String toExecutableDSLTaskName(TaskAppNode taskApp) {
            StringBuilder taskDefName = new StringBuilder();
            taskDefName.append(TaskNode.getTaskPrefix(this.taskName));
            if (taskApp.hasLabel()) {
                taskDefName.append(taskApp.getLabelString());
            } else {
                taskDefName.append(taskApp.getName());
            }
            return taskDefName.toString();
        }

        public String getDSL() {
            return this.dsl.toString();
        }
    }
}

