/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.AppParser;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.FlowNode;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskNode;
import org.springframework.cloud.dataflow.core.dsl.TaskTokenizer;
import org.springframework.cloud.dataflow.core.dsl.TaskValidationException;
import org.springframework.cloud.dataflow.core.dsl.TaskValidationProblem;
import org.springframework.cloud.dataflow.core.dsl.TaskValidatorVisitor;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.core.dsl.Tokens;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;
import org.springframework.util.Assert;

public class TaskParser
extends AppParser {
    public static final ArgumentNode[] NO_ARGUMENTS = new ArgumentNode[0];
    private final String taskName;
    private final String taskDefinition;
    private final boolean inAppMode;
    private final boolean validate;

    public TaskParser(String taskName, String taskDefinition, boolean inAppMode, boolean validate) {
        super(new TaskTokenizer().getTokens(taskDefinition));
        Assert.notNull((Object)taskName, (String)"taskName must be a non-null string");
        Assert.notNull((Object)taskDefinition, (String)"taskDefinition must be a non-null string");
        this.taskName = taskName;
        this.inAppMode = inAppMode;
        this.taskDefinition = taskDefinition.trim();
        this.validate = validate;
    }

    public TaskNode parse() {
        List<LabelledTaskNode> sequences = this.eatSequences();
        if (this.taskName != null && !this.isValidName(this.taskName)) {
            throw new ParseException(this.taskName, 0, DSLMessage.ILLEGAL_TASK_NAME, this.taskName);
        }
        TaskNode taskNode = new TaskNode(this.taskName, this.taskDefinition, sequences, this.inAppMode);
        if (this.getTokens().hasNext()) {
            this.getTokens().raiseException(this.getTokens().peek().startPos, DSLMessage.TASK_MORE_INPUT, this.toString(this.getTokens().next()));
        }
        if (this.validate) {
            TaskValidatorVisitor validator = new TaskValidatorVisitor();
            taskNode.accept(validator);
            List<TaskValidationProblem> problems = validator.getProblems();
            if (!problems.isEmpty()) {
                throw new TaskValidationException(taskNode, problems);
            }
        }
        return taskNode;
    }

    private List<LabelledTaskNode> eatSequences() {
        ArrayList<LabelledTaskNode> sequence = new ArrayList<LabelledTaskNode>();
        sequence.add(this.parseTaskNode());
        while (this.getTokens().hasNext() && (this.nextTokenIsOnNewline() || this.maybeEat(TokenKind.SEMICOLON))) {
            sequence.add(this.parseTaskNode());
        }
        return sequence;
    }

    private boolean nextTokenIsOnNewline() {
        Token nextToken = this.peek();
        Token lastToken = this.peek(-1);
        int lastTokenLine = this.getTokens().getLine(lastToken);
        int nextTokenLine = this.getTokens().getLine(nextToken);
        return nextTokenLine > lastTokenLine;
    }

    private Token maybeEatLabel() {
        if (this.peek(TokenKind.IDENTIFIER) && this.peek(1) != null && this.peek(1).isKind(TokenKind.COLON)) {
            Token labelToken = this.eat();
            this.eat(TokenKind.COLON);
            return labelToken;
        }
        return null;
    }

    private LabelledTaskNode parseTaskNode() {
        if (this.maybeEat(TokenKind.OPEN_PAREN)) {
            LabelledTaskNode node = this.parseTaskNode();
            this.eat(TokenKind.CLOSE_PAREN);
            return node;
        }
        Token label = this.maybeEatLabel();
        if (label != null) {
            if (this.peek(TokenKind.OPEN_PAREN)) {
                this.getTokens().raiseException(this.peek().startPos, DSLMessage.TASK_NO_LABELS_ON_PARENS, new Object[0]);
            } else {
                Token secondLabel = this.maybeEatLabel();
                if (secondLabel != null) {
                    this.getTokens().raiseException(secondLabel.startPos, DSLMessage.NO_DOUBLE_LABELS, new Object[0]);
                }
            }
        }
        if (this.peek(TokenKind.LT)) {
            LabelledTaskNode node = this.parseSplit();
            node.setLabel(label);
            return this.parseFlow(node);
        }
        TaskAppNode app = this.eatTaskApp(true);
        app.setLabel(label);
        return this.parseFlow(app);
    }

    private FlowNode parseFlow(LabelledTaskNode firstNodeInFlow) {
        ArrayList<LabelledTaskNode> nodes = new ArrayList<LabelledTaskNode>();
        nodes.add(firstNodeInFlow);
        while (this.maybeEat(TokenKind.ANDAND)) {
            LabelledTaskNode nextNode = this.parseTaskNode();
            if (nextNode instanceof FlowNode) {
                nodes.addAll(nextNode.getSeries());
                continue;
            }
            nodes.add(nextNode);
        }
        FlowNode f = new FlowNode(nodes);
        f.setLabel(firstNodeInFlow.getLabel());
        return f;
    }

    private LabelledTaskNode parseSplit() {
        ArrayList<LabelledTaskNode> flows = new ArrayList<LabelledTaskNode>();
        Token startSplit = this.eat(TokenKind.LT);
        flows.add(this.parseTaskNode());
        while (this.maybeEat(TokenKind.DOUBLEPIPE)) {
            flows.add(this.parseTaskNode());
        }
        Token endSplit = this.eat(TokenKind.GT);
        return new SplitNode(startSplit.startPos, endSplit.endPos, flows);
    }

    private TaskAppNode eatTaskApp(boolean transitionsAllowed) {
        ArgumentNode[] arguments;
        Token name = this.eat();
        if (!name.isKind(TokenKind.IDENTIFIER)) {
            this.getTokens().raiseException(name.startPos, DSLMessage.EXPECTED_APPNAME, name.data != null ? name.data : new String(name.getKind().tokenChars));
        }
        this.getTokens().checkpoint();
        ArgumentNode[] argumentNodeArray = arguments = this.inAppMode ? this.maybeEatAppArgs() : null;
        if (!this.inAppMode && this.peek(TokenKind.DOUBLE_MINUS)) {
            this.getTokens().raiseException(this.peek().startPos, DSLMessage.TASK_ARGUMENTS_NOT_ALLOWED_UNLESS_IN_APP_MODE, new Object[0]);
        }
        List<TransitionNode> transitions = transitionsAllowed ? this.maybeEatTransitions() : Collections.emptyList();
        return new TaskAppNode(name, arguments, transitions);
    }

    private ArgumentNode[] maybeEatAppArgs() {
        Tokens tokens = this.getTokens();
        ArrayList<ArgumentNode> args = null;
        if (tokens.peek(TokenKind.DOUBLE_MINUS) && tokens.isNextAdjacent()) {
            tokens.raiseException(tokens.peek().startPos, DSLMessage.EXPECTED_WHITESPACE_AFTER_APP_BEFORE_ARGUMENT, new Object[0]);
        }
        while (tokens.peek(TokenKind.DOUBLE_MINUS)) {
            Token dashDash = tokens.next();
            if (tokens.peek(TokenKind.IDENTIFIER) && !tokens.isNextAdjacent()) {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_NAME, new Object[0]);
            }
            List<Token> argNameComponents = this.eatDottedName();
            if (tokens.peek(TokenKind.EQUALS) && !tokens.isNextAdjacent()) {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_EQUALS, new Object[0]);
            }
            tokens.eat(TokenKind.EQUALS);
            if (tokens.peek(TokenKind.IDENTIFIER) && !tokens.isNextAdjacent()) {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_VALUE, new Object[0]);
            }
            Token t = tokens.peek();
            String argValue = this.eatArgValue();
            tokens.checkpoint();
            if (args == null) {
                args = new ArrayList<ArgumentNode>();
            }
            args.add(new ArgumentNode(this.toData(argNameComponents), argValue, dashDash.startPos, t.endPos));
        }
        return args == null ? NO_ARGUMENTS : args.toArray(new ArgumentNode[args.size()]);
    }

    private List<TransitionNode> maybeEatTransitions() {
        ArrayList<TransitionNode> transitions = new ArrayList<TransitionNode>();
        Token transitionOn = null;
        while (true) {
            if (this.peek(TokenKind.ARROW)) {
                this.getTokens().raiseException(this.peek().startPos, DSLMessage.TASK_ARROW_SHOULD_BE_PRECEDED_BY_CODE, new Object[0]);
                break;
            }
            Token possibleArrow = this.peek(1);
            if (possibleArrow == null || possibleArrow.getKind() != TokenKind.ARROW || (transitionOn = this.peek()) == null || transitionOn.getKind() != TokenKind.IDENTIFIER && transitionOn.getKind() != TokenKind.LITERAL_STRING && transitionOn.getKind() != TokenKind.STAR) break;
            this.eat();
            if (!this.maybeEat(TokenKind.ARROW)) {
                this.getTokens().raiseException(transitionOn.startPos, DSLMessage.TASK_MISSING_TRANSITION_ARROW, new Object[0]);
            }
            TransitionNode t = null;
            if (this.maybeEat(TokenKind.COLON)) {
                Token labelReference = this.eat(TokenKind.IDENTIFIER);
                t = TransitionNode.toLabelReference(transitionOn, labelReference);
            } else {
                Token label = this.maybeEatLabel();
                TaskAppNode task = this.eatTaskApp(false);
                task.setLabel(label);
                t = TransitionNode.toAnotherTask(transitionOn, task);
            }
            if (t.isExitCodeCheck() && !t.getStatusToCheck().equals("*")) {
                try {
                    Integer.parseInt(t.getStatusToCheck());
                }
                catch (NumberFormatException nfe) {
                    this.getTokens().raiseException(transitionOn.startPos, DSLMessage.TASK_UNQUOTED_TRANSITION_CHECK_MUST_BE_NUMBER, t.getStatusToCheck());
                }
            }
            transitions.add(t);
        }
        return transitions;
    }

    public String toString() {
        return this.getTokens().toString();
    }

    private boolean maybeEat(TokenKind desiredTokenKind) {
        if (this.getTokens().peek(desiredTokenKind)) {
            this.getTokens().eat(desiredTokenKind);
            return true;
        }
        return false;
    }

    private Token eat(TokenKind tokenKind) {
        return this.getTokens().eat(tokenKind);
    }

    private Token eat() {
        return this.getTokens().eat();
    }

    private Token peek() {
        return this.getTokens().peek();
    }

    private Token peek(int howFarAhead) {
        return this.getTokens().peek(howFarAhead);
    }

    private boolean peek(TokenKind desiredTokenKind) {
        return this.getTokens().peek(desiredTokenKind);
    }
}

