/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;

public class TaskValidationProblem {
    private final String taskDsl;
    private final int offset;
    private final DSLMessage message;

    public TaskValidationProblem(String taskDsl, int offset, DSLMessage message) {
        this.taskDsl = taskDsl;
        this.offset = offset;
        this.message = message;
    }

    public String toString() {
        return this.message.formatMessage(this.offset, new Object[0]);
    }

    public String toStringWithContext() {
        int offsetOnLine;
        StringBuilder s = new StringBuilder();
        s.append(this.message.formatMessage(this.offset, new Object[0]));
        int startOfLine = this.getStartOfLine(this.offset);
        if (this.taskDsl != null && this.taskDsl.length() > 0) {
            s.append("\n").append(this.taskDsl.substring(startOfLine)).append("\n");
        }
        if ((offsetOnLine = this.offset - startOfLine) >= 0) {
            for (int i = 0; i < offsetOnLine; ++i) {
                s.append(' ');
            }
            s.append("^\n");
        }
        return s.toString();
    }

    public DSLMessage getMessage() {
        return this.message;
    }

    public int getOffset() {
        return this.offset;
    }

    private int getStartOfLine(int position) {
        for (int p = 0; p < position; ++p) {
            if (this.taskDsl.charAt(p) != '\n') continue;
            return p + 1;
        }
        return 0;
    }

    public Map<String, Object> toExceptionDescriptor() {
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        String text = this.message.formatMessage(this.offset, new Object[0]);
        descriptor.put("message", text);
        descriptor.put("position", this.offset);
        return descriptor;
    }
}

